/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.azureopenai.AzureOpenAiResponseHandler;
import org.elasticsearch.xpack.inference.external.http.retry.RequestSender;
import org.elasticsearch.xpack.inference.external.http.retry.ResponseHandler;
import org.elasticsearch.xpack.inference.external.http.sender.AzureOpenAiRequestManager;
import org.elasticsearch.xpack.inference.external.http.sender.ExecutableInferenceRequest;
import org.elasticsearch.xpack.inference.external.request.azureopenai.AzureOpenAiEmbeddingsRequest;
import org.elasticsearch.xpack.inference.external.response.openai.OpenAiEmbeddingsResponseEntity;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsModel;

public class AzureOpenAiEmbeddingsRequestManager
extends AzureOpenAiRequestManager {
    private static final Logger logger = LogManager.getLogger(AzureOpenAiEmbeddingsRequestManager.class);
    private static final ResponseHandler HANDLER = AzureOpenAiEmbeddingsRequestManager.createEmbeddingsHandler();
    private final Truncator truncator;
    private final AzureOpenAiEmbeddingsModel model;

    private static ResponseHandler createEmbeddingsHandler() {
        return new AzureOpenAiResponseHandler("azure openai text embedding", OpenAiEmbeddingsResponseEntity::fromResponse);
    }

    public static AzureOpenAiEmbeddingsRequestManager of(AzureOpenAiEmbeddingsModel model, Truncator truncator, ThreadPool threadPool) {
        return new AzureOpenAiEmbeddingsRequestManager(Objects.requireNonNull(model), Objects.requireNonNull(truncator), Objects.requireNonNull(threadPool));
    }

    public AzureOpenAiEmbeddingsRequestManager(AzureOpenAiEmbeddingsModel model, Truncator truncator, ThreadPool threadPool) {
        super(threadPool, model);
        this.model = Objects.requireNonNull(model);
        this.truncator = Objects.requireNonNull(truncator);
    }

    @Override
    public Runnable create(String query, List<String> input, RequestSender requestSender, Supplier<Boolean> hasRequestCompletedFunction, HttpClientContext context, ActionListener<InferenceServiceResults> listener) {
        Truncator.TruncationResult truncatedInput = Truncator.truncate(input, this.model.getServiceSettings().maxInputTokens());
        AzureOpenAiEmbeddingsRequest request = new AzureOpenAiEmbeddingsRequest(this.truncator, truncatedInput, this.model);
        return new ExecutableInferenceRequest(requestSender, logger, request, context, HANDLER, hasRequestCompletedFunction, listener);
    }
}

