/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.azureopenai;

import java.util.Objects;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsModel;

public record AzureOpenAiAccount(String resourceName, String deploymentId, String apiVersion, @Nullable SecureString apiKey, @Nullable SecureString entraId) {
    public AzureOpenAiAccount {
        Objects.requireNonNull(resourceName);
        Objects.requireNonNull(deploymentId);
        Objects.requireNonNull(apiVersion);
        Objects.requireNonNullElse(apiKey, entraId);
    }

    public static AzureOpenAiAccount fromModel(AzureOpenAiEmbeddingsModel model) {
        return new AzureOpenAiAccount(model.getServiceSettings().resourceName(), model.getServiceSettings().deploymentId(), model.getServiceSettings().apiVersion(), model.getSecretSettings().apiKey(), model.getSecretSettings().entraId());
    }
}

