/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action.azureopenai;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.azureopenai.AzureOpenAiActionVisitor;
import org.elasticsearch.xpack.inference.external.action.azureopenai.AzureOpenAiEmbeddingsAction;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.azureopenai.embeddings.AzureOpenAiEmbeddingsModel;

public class AzureOpenAiActionCreator
implements AzureOpenAiActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public AzureOpenAiActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(AzureOpenAiEmbeddingsModel model, Map<String, Object> taskSettings) {
        AzureOpenAiEmbeddingsModel overriddenModel = AzureOpenAiEmbeddingsModel.of(model, taskSettings);
        return new AzureOpenAiEmbeddingsAction(this.sender, overriddenModel, this.serviceComponents);
    }
}

