/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.action;

import java.net.URI;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.rest.RestStatus;

public class ActionUtils {
    public static ActionListener<InferenceServiceResults> wrapFailuresInElasticsearchException(String errorMessage, ActionListener<InferenceServiceResults> listener) {
        return ActionListener.wrap(arg_0 -> listener.onResponse(arg_0), e -> {
            Throwable unwrappedException = ExceptionsHelper.unwrapCause((Throwable)e);
            if (unwrappedException instanceof ElasticsearchException) {
                ElasticsearchException esException = (ElasticsearchException)unwrappedException;
                listener.onFailure((Exception)esException);
            } else {
                listener.onFailure((Exception)ActionUtils.createInternalServerError(unwrappedException, errorMessage));
            }
        });
    }

    public static ElasticsearchStatusException createInternalServerError(Throwable e, String message) {
        return new ElasticsearchStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, e, new Object[0]);
    }

    public static String constructFailedToSendRequestMessage(@Nullable URI uri, String message) {
        if (uri != null) {
            return Strings.format((String)"Failed to send %s request to [%s]", (Object[])new Object[]{message, uri});
        }
        return Strings.format((String)"Failed to send %s request", (Object[])new Object[]{message});
    }

    private ActionUtils() {
    }
}

