/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.common;

import com.ibm.icu.text.BreakIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class WordBoundaryChunker {
    private BreakIterator wordIterator = BreakIterator.getWordInstance((Locale)Locale.ROOT);

    public List<String> chunk(String input, int chunkSize, int overlap) {
        if (overlap > 0 && overlap > chunkSize / 2) {
            throw new IllegalArgumentException("Invalid chunking parameters, overlap [" + overlap + "] must be < chunk size / 2 [" + chunkSize + " / 2 = " + chunkSize / 2 + "]");
        }
        if (overlap < 0) {
            throw new IllegalArgumentException("Invalid chunking parameters, overlap [" + overlap + "] must be >= 0");
        }
        if (input.isEmpty()) {
            return List.of("");
        }
        ArrayList<String> chunks = new ArrayList<String>();
        int chunkSizeLessOverlap = chunkSize - overlap;
        int wordsInChunkCountIncludingOverlap = 0;
        int nextWindowStart = 0;
        int windowStart = 0;
        int wordsSinceStartWindowWasMarked = 0;
        this.wordIterator.setText(input);
        int boundary = this.wordIterator.next();
        while (boundary != -1) {
            if (this.wordIterator.getRuleStatus() != 0) {
                ++wordsSinceStartWindowWasMarked;
                if (++wordsInChunkCountIncludingOverlap >= chunkSize) {
                    chunks.add(input.substring(windowStart, boundary));
                    wordsInChunkCountIncludingOverlap = overlap;
                    if (overlap == 0) {
                        nextWindowStart = boundary;
                    }
                    windowStart = nextWindowStart;
                }
                if (wordsSinceStartWindowWasMarked == chunkSizeLessOverlap) {
                    nextWindowStart = boundary;
                    wordsSinceStartWindowWasMarked = 0;
                }
            }
            boundary = this.wordIterator.next();
        }
        if (wordsInChunkCountIncludingOverlap > overlap || chunks.isEmpty()) {
            chunks.add(input.substring(windowStart));
        }
        return chunks;
    }
}

