/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.common;

import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.elasticsearch.core.Nullable;

public class AdjustableCapacityBlockingQueue<E> {
    private BlockingQueue<E> currentQueue;
    private final BlockingQueue<E> prioritizedReadingQueue;
    private final QueueCreator<E> queueCreator;
    private final ReentrantReadWriteLock lock;

    public AdjustableCapacityBlockingQueue(QueueCreator<E> queueCreator, @Nullable Integer initialCapacity) {
        this.queueCreator = Objects.requireNonNull(queueCreator);
        this.currentQueue = AdjustableCapacityBlockingQueue.createCurrentQueue(queueCreator, initialCapacity);
        this.lock = new ReentrantReadWriteLock();
        this.prioritizedReadingQueue = queueCreator.create();
    }

    private static <E> BlockingQueue<E> createCurrentQueue(QueueCreator<E> queueCreator, @Nullable Integer initialCapacity) {
        if (initialCapacity == null) {
            return queueCreator.create();
        }
        return queueCreator.create(initialCapacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCapacity(int newCapacity) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            BlockingQueue<E> newQueue = this.queueCreator.create(newCapacity);
            if (this.currentQueue.size() > newCapacity) {
                this.currentQueue.drainTo(this.prioritizedReadingQueue, this.currentQueue.size() - newCapacity);
            }
            this.currentQueue.drainTo(newQueue, newCapacity);
            this.currentQueue = newQueue;
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(E item) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = this.currentQueue.offer(item);
            return bl;
        }
        finally {
            readLock.unlock();
        }
    }

    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection<? super E> c, int maxElements) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            int numberOfDrainedOldItems = this.prioritizedReadingQueue.drainTo(c, maxElements);
            int numberOfDrainedCurrentItems = this.currentQueue.drainTo(c, maxElements - numberOfDrainedOldItems);
            int n = numberOfDrainedCurrentItems + numberOfDrainedOldItems;
            return n;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E poll(long timeout, TimeUnit timeUnit) throws InterruptedException {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lockInterruptibly();
        try {
            Object oldItem = this.prioritizedReadingQueue.poll();
            if (oldItem != null) {
                Object e = oldItem;
                return e;
            }
            E e = this.currentQueue.poll(timeout, timeUnit);
            return e;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E take() throws InterruptedException {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lockInterruptibly();
        try {
            Object oldItem = this.prioritizedReadingQueue.poll();
            if (oldItem != null) {
                Object e = oldItem;
                return e;
            }
            E e = this.currentQueue.take();
            return e;
        }
        finally {
            readLock.unlock();
        }
    }

    public int size() {
        return this.currentQueue.size() + this.prioritizedReadingQueue.size();
    }

    public int remainingCapacity() {
        return this.currentQueue.remainingCapacity();
    }

    public static interface QueueCreator<E> {
        public BlockingQueue<E> create(int var1);

        public BlockingQueue<E> create();
    }
}

