/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.core.IOUtils;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.inference.InferenceServiceExtension;
import org.elasticsearch.inference.InferenceServiceRegistry;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.ExtensiblePlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ScalingExecutorBuilder;
import org.elasticsearch.xpack.core.action.XPackUsageFeatureAction;
import org.elasticsearch.xpack.core.inference.action.DeleteInferenceModelAction;
import org.elasticsearch.xpack.core.inference.action.GetInferenceModelAction;
import org.elasticsearch.xpack.core.inference.action.InferenceAction;
import org.elasticsearch.xpack.core.inference.action.PutInferenceModelAction;
import org.elasticsearch.xpack.inference.InferenceIndex;
import org.elasticsearch.xpack.inference.InferenceNamedWriteablesProvider;
import org.elasticsearch.xpack.inference.InferenceSecretsIndex;
import org.elasticsearch.xpack.inference.action.TransportDeleteInferenceModelAction;
import org.elasticsearch.xpack.inference.action.TransportGetInferenceModelAction;
import org.elasticsearch.xpack.inference.action.TransportInferenceAction;
import org.elasticsearch.xpack.inference.action.TransportInferenceUsageAction;
import org.elasticsearch.xpack.inference.action.TransportPutInferenceModelAction;
import org.elasticsearch.xpack.inference.common.Truncator;
import org.elasticsearch.xpack.inference.external.http.HttpClientManager;
import org.elasticsearch.xpack.inference.external.http.HttpSettings;
import org.elasticsearch.xpack.inference.external.http.retry.RetrySettings;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSender;
import org.elasticsearch.xpack.inference.external.http.sender.RequestExecutorServiceSettings;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;
import org.elasticsearch.xpack.inference.registry.ModelRegistry;
import org.elasticsearch.xpack.inference.rest.RestDeleteInferenceModelAction;
import org.elasticsearch.xpack.inference.rest.RestGetInferenceModelAction;
import org.elasticsearch.xpack.inference.rest.RestInferenceAction;
import org.elasticsearch.xpack.inference.rest.RestPutInferenceModelAction;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.azureopenai.AzureOpenAiService;
import org.elasticsearch.xpack.inference.services.cohere.CohereService;
import org.elasticsearch.xpack.inference.services.elasticsearch.ElasticsearchInternalService;
import org.elasticsearch.xpack.inference.services.elser.ElserInternalService;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceService;
import org.elasticsearch.xpack.inference.services.huggingface.elser.HuggingFaceElserService;
import org.elasticsearch.xpack.inference.services.openai.OpenAiService;

public class InferencePlugin
extends Plugin
implements ActionPlugin,
ExtensiblePlugin,
SystemIndexPlugin {
    public static final Setting<Boolean> SKIP_VALIDATE_AND_START = Setting.boolSetting((String)"xpack.inference.skip_validate_and_start", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final String NAME = "inference";
    public static final String UTILITY_THREAD_POOL_NAME = "inference_utility";
    private final Settings settings;
    private final SetOnce<HttpRequestSender.Factory> httpFactory = new SetOnce();
    private final SetOnce<ServiceComponents> serviceComponents = new SetOnce();
    private final SetOnce<InferenceServiceRegistry> inferenceServiceRegistry = new SetOnce();
    private List<InferenceServiceExtension> inferenceServiceExtensions;

    public InferencePlugin(Settings settings) {
        this.settings = settings;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return List.of(new ActionPlugin.ActionHandler((ActionType)InferenceAction.INSTANCE, TransportInferenceAction.class), new ActionPlugin.ActionHandler((ActionType)GetInferenceModelAction.INSTANCE, TransportGetInferenceModelAction.class), new ActionPlugin.ActionHandler((ActionType)PutInferenceModelAction.INSTANCE, TransportPutInferenceModelAction.class), new ActionPlugin.ActionHandler((ActionType)DeleteInferenceModelAction.INSTANCE, TransportDeleteInferenceModelAction.class), new ActionPlugin.ActionHandler(XPackUsageFeatureAction.INFERENCE, TransportInferenceUsageAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return List.of(new RestInferenceAction(), new RestGetInferenceModelAction(), new RestPutInferenceModelAction(), new RestDeleteInferenceModelAction());
    }

    public Collection<?> createComponents(Plugin.PluginServices services) {
        ThrottlerManager throttlerManager = new ThrottlerManager(this.settings, services.threadPool(), services.clusterService());
        Truncator truncator = new Truncator(this.settings, services.clusterService());
        this.serviceComponents.set((Object)new ServiceComponents(services.threadPool(), throttlerManager, this.settings, truncator));
        HttpRequestSender.Factory httpRequestSenderFactory = new HttpRequestSender.Factory((ServiceComponents)this.serviceComponents.get(), HttpClientManager.create(this.settings, services.threadPool(), services.clusterService(), throttlerManager), services.clusterService());
        this.httpFactory.set((Object)httpRequestSenderFactory);
        ModelRegistry modelRegistry = new ModelRegistry(services.client());
        if (this.inferenceServiceExtensions == null) {
            this.inferenceServiceExtensions = new ArrayList<InferenceServiceExtension>();
        }
        ArrayList<InferenceServiceExtension> inferenceServices = new ArrayList<InferenceServiceExtension>(this.inferenceServiceExtensions);
        inferenceServices.add(this::getInferenceServiceFactories);
        InferenceServiceExtension.InferenceServiceFactoryContext factoryContext = new InferenceServiceExtension.InferenceServiceFactoryContext(services.client());
        InferenceServiceRegistry registry = new InferenceServiceRegistry(inferenceServices, factoryContext);
        registry.init(services.client());
        this.inferenceServiceRegistry.set((Object)registry);
        return List.of(modelRegistry, registry);
    }

    public void loadExtensions(ExtensiblePlugin.ExtensionLoader loader) {
        this.inferenceServiceExtensions = loader.loadExtensions(InferenceServiceExtension.class);
    }

    public List<InferenceServiceExtension.Factory> getInferenceServiceFactories() {
        return List.of(ElserInternalService::new, context -> new HuggingFaceElserService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new HuggingFaceService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new OpenAiService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new CohereService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), context -> new AzureOpenAiService((HttpRequestSender.Factory)this.httpFactory.get(), (ServiceComponents)this.serviceComponents.get()), ElasticsearchInternalService::new);
    }

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.addAll(InferenceNamedWriteablesProvider.getNamedWriteables());
        return entries;
    }

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return List.of(SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.INTERNAL_MANAGED).setIndexPattern(".inference*").setPrimaryIndex(".inference").setDescription("Contains inference service and model configuration").setMappings(InferenceIndex.mappings()).setSettings(InferenceIndex.settings()).setVersionMetaKey("version").setOrigin(NAME).build(), SystemIndexDescriptor.builder().setType(SystemIndexDescriptor.Type.INTERNAL_MANAGED).setIndexPattern(".secrets-inference*").setPrimaryIndex(".secrets-inference").setDescription("Contains inference service secrets").setMappings(InferenceSecretsIndex.mappings()).setSettings(InferenceSecretsIndex.settings()).setVersionMetaKey("version").setOrigin(NAME).setNetNew().build());
    }

    public List<ExecutorBuilder<?>> getExecutorBuilders(Settings settingsToUse) {
        return List.of(new ScalingExecutorBuilder(UTILITY_THREAD_POOL_NAME, 0, 10, TimeValue.timeValueMinutes((long)10L), false, "xpack.inference.utility_thread_pool"));
    }

    public List<Setting<?>> getSettings() {
        return Stream.of(HttpSettings.getSettings(), HttpClientManager.getSettings(), ThrottlerManager.getSettings(), RetrySettings.getSettingsDefinitions(), Truncator.getSettings(), RequestExecutorServiceSettings.getSettingsDefinitions(), List.of(SKIP_VALIDATE_AND_START)).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public String getFeatureName() {
        return "inference_plugin";
    }

    public String getFeatureDescription() {
        return "Inference plugin for managing inference services and inference";
    }

    public void close() {
        ServiceComponents serviceComponentsRef = (ServiceComponents)this.serviceComponents.get();
        ThrottlerManager throttlerToClose = serviceComponentsRef != null ? serviceComponentsRef.throttlerManager() : null;
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)this.inferenceServiceRegistry.get(), throttlerToClose});
    }
}

