/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.execution.search.extractor;

import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ql.InvalidArgumentException;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class AbstractFieldHitExtractor
implements HitExtractor {
    private final String fieldName;
    private final String hitName;
    private final DataType dataType;
    private final ZoneId zoneId;
    protected MultiValueSupport multiValueSupport;

    protected AbstractFieldHitExtractor(String name, DataType dataType, ZoneId zoneId) {
        this(name, dataType, zoneId, null, MultiValueSupport.NONE);
    }

    protected AbstractFieldHitExtractor(String name, DataType dataType, ZoneId zoneId, MultiValueSupport multiValueSupport) {
        this(name, dataType, zoneId, null, multiValueSupport);
    }

    protected AbstractFieldHitExtractor(String name, DataType dataType, ZoneId zoneId, String hitName, MultiValueSupport multiValueSupport) {
        this.fieldName = name;
        this.dataType = dataType;
        this.zoneId = zoneId;
        this.multiValueSupport = multiValueSupport;
        this.hitName = hitName;
        if (hitName != null && !name.contains(hitName)) {
            throw new QlIllegalArgumentException("Hitname [{}] specified but not part of the name [{}]", hitName, name);
        }
    }

    protected AbstractFieldHitExtractor(StreamInput in) throws IOException {
        this.fieldName = in.readString();
        String typeName = in.readOptionalString();
        this.dataType = typeName != null ? this.loadTypeFromName(typeName) : null;
        this.hitName = in.readOptionalString();
        this.multiValueSupport = in.getTransportVersion().before((VersionId)TransportVersions.V_8_6_0) ? (in.readBoolean() ? MultiValueSupport.LENIENT : MultiValueSupport.NONE) : (MultiValueSupport)in.readEnum(MultiValueSupport.class);
        this.zoneId = this.readZoneId(in);
    }

    protected DataType loadTypeFromName(String typeName) {
        return DataTypes.fromTypeName(typeName);
    }

    protected abstract ZoneId readZoneId(StreamInput var1) throws IOException;

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeOptionalString(this.dataType == null ? null : this.dataType.typeName());
        out.writeOptionalString(this.hitName);
        if (out.getTransportVersion().before((VersionId)TransportVersions.V_8_6_0)) {
            out.writeBoolean(this.multiValueSupport != MultiValueSupport.NONE);
        } else {
            out.writeEnum((Enum)this.multiValueSupport);
        }
    }

    @Override
    public Object extract(SearchHit hit) {
        Object value = null;
        DocumentField field = null;
        if (this.hitName != null) {
            value = this.unwrapFieldsMultiValue(this.extractNestedField(hit));
        } else {
            field = hit.field(this.fieldName);
            if (field != null) {
                value = this.unwrapFieldsMultiValue(field.getValues());
            }
        }
        return value;
    }

    private Object extractNestedField(SearchHit hit) {
        List<Object> value;
        DocumentField field;
        String tempHitname = this.hitName;
        ArrayList<String> remainingPath = new ArrayList<String>();
        while ((field = hit.field(tempHitname)) == null) {
            int indexOfDot = tempHitname.lastIndexOf(46);
            if (indexOfDot < 0) {
                return null;
            }
            remainingPath.add(0, tempHitname.substring(indexOfDot + 1));
            tempHitname = tempHitname.substring(0, indexOfDot);
        }
        if (remainingPath.size() > 0) {
            List values = field.getValues();
            Iterator pathIterator = remainingPath.iterator();
            while (pathIterator.hasNext()) {
                Object pathElement = (String)pathIterator.next();
                Map elements = (Map)values.get(0);
                values = (List)elements.get(pathElement);
                while (values == null) {
                    pathElement = (String)pathElement + "." + (String)pathIterator.next();
                    values = (List)elements.get(pathElement);
                }
            }
            value = ((Map)values.get(0)).get(this.fieldName.substring(this.hitName.length() + 1));
        } else {
            value = field.getValues();
        }
        return value;
    }

    protected Object unwrapFieldsMultiValue(Object values) {
        Object unwrapped;
        if (values == null) {
            return null;
        }
        if (values instanceof Map && this.hitName != null) {
            return this.unwrapFieldsMultiValue(((Map)((Object)values)).get(this.fieldName.substring(this.hitName.length() + 1)));
        }
        if (values instanceof List) {
            List list = values;
            if (list.isEmpty()) {
                return null;
            }
            if (!this.isPrimitive(list)) {
                if (list.size() == 1 || this.multiValueSupport == MultiValueSupport.LENIENT) {
                    return this.unwrapFieldsMultiValue(list.get(0));
                }
                if (this.multiValueSupport == MultiValueSupport.FULL) {
                    ArrayList<Object> unwrappedValues = new ArrayList<Object>();
                    for (Object value : list) {
                        unwrappedValues.add(this.unwrapFieldsMultiValue(value));
                    }
                    values = unwrappedValues;
                } else {
                    throw new InvalidArgumentException("Arrays (returned by [{}]) are not supported", this.fieldName);
                }
            }
        }
        if ((unwrapped = this.unwrapCustomValue(values)) != null && !AbstractFieldHitExtractor.isListOfNulls(unwrapped)) {
            return unwrapped;
        }
        return values;
    }

    private static boolean isListOfNulls(Object unwrapped) {
        if (unwrapped instanceof List) {
            List list = (List)unwrapped;
            if (list.size() == 0) {
                return false;
            }
            for (Object o : list) {
                if (o == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected abstract Object unwrapCustomValue(Object var1);

    protected abstract boolean isPrimitive(List<?> var1);

    @Override
    public String hitName() {
        return this.hitName;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public ZoneId zoneId() {
        return this.zoneId;
    }

    public DataType dataType() {
        return this.dataType;
    }

    public MultiValueSupport multiValueSupport() {
        return this.multiValueSupport;
    }

    public String toString() {
        return this.fieldName + "@" + this.hitName + "@" + this.zoneId;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        AbstractFieldHitExtractor other = (AbstractFieldHitExtractor)obj;
        return this.fieldName.equals(other.fieldName) && this.hitName.equals(other.hitName) && this.multiValueSupport == other.multiValueSupport;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.hitName, this.multiValueSupport});
    }

    public static enum MultiValueSupport {
        NONE,
        LENIENT,
        FULL;

    }
}

