/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.downsample.DownsampleConfig;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.persistent.PersistentTaskParams;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public record DownsampleShardTaskParams(DownsampleConfig downsampleConfig, String downsampleIndex, long indexStartTimeMillis, long indexEndTimeMillis, ShardId shardId, String[] metrics, String[] labels, String[] dimensions) implements PersistentTaskParams
{
    private static final TransportVersion V_8_13_0 = TransportVersions.ML_MODEL_IN_SERVICE_SETTINGS;
    public static final String NAME = "rollup-shard";
    private static final ParseField DOWNSAMPLE_CONFIG = new ParseField("downsample_config", new String[0]);
    private static final ParseField DOWNSAMPLE_INDEX = new ParseField("rollup_index", new String[0]);
    private static final ParseField INDEX_START_TIME_MILLIS = new ParseField("index_start_time_millis", new String[0]);
    private static final ParseField INDEX_END_TIME_MILLIS = new ParseField("index_end_time_millis", new String[0]);
    private static final ParseField SHARD_ID = new ParseField("shard_id", new String[0]);
    private static final ParseField METRICS = new ParseField("metrics", new String[0]);
    private static final ParseField LABELS = new ParseField("labels", new String[0]);
    private static final ParseField DIMENSIONS = new ParseField("dimensions", new String[0]);
    public static final ObjectParser<Builder, Void> PARSER = new ObjectParser("rollup-shard");

    DownsampleShardTaskParams(StreamInput in) throws IOException {
        this(new DownsampleConfig(in), in.readString(), in.readVLong(), in.readVLong(), new ShardId(in), in.readStringArray(), in.readStringArray(), in.getTransportVersion().onOrAfter((VersionId)V_8_13_0) ? in.readOptionalStringArray() : new String[]{});
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DOWNSAMPLE_CONFIG.getPreferredName(), (ToXContent)this.downsampleConfig);
        builder.field(DOWNSAMPLE_INDEX.getPreferredName(), this.downsampleIndex);
        builder.field(INDEX_START_TIME_MILLIS.getPreferredName(), this.indexStartTimeMillis);
        builder.field(INDEX_END_TIME_MILLIS.getPreferredName(), this.indexEndTimeMillis);
        builder.field(SHARD_ID.getPreferredName(), (ToXContent)this.shardId);
        builder.array(METRICS.getPreferredName(), this.metrics);
        builder.array(LABELS.getPreferredName(), this.labels);
        if (this.dimensions.length > 0) {
            builder.array(DIMENSIONS.getPreferredName(), this.dimensions);
        }
        return builder.endObject();
    }

    public String getWriteableName() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.V_8_10_X;
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.downsampleConfig.writeTo(out);
        out.writeString(this.downsampleIndex);
        out.writeVLong(this.indexStartTimeMillis);
        out.writeVLong(this.indexEndTimeMillis);
        this.shardId.writeTo(out);
        out.writeStringArray(this.metrics);
        out.writeStringArray(this.labels);
        if (out.getTransportVersion().onOrAfter((VersionId)V_8_13_0)) {
            out.writeOptionalStringArray(this.dimensions);
        }
    }

    public static DownsampleShardTaskParams fromXContent(XContentParser parser) throws IOException {
        Builder builder = new Builder();
        PARSER.parse(parser, (Object)builder, null);
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownsampleShardTaskParams that = (DownsampleShardTaskParams)o;
        return this.indexStartTimeMillis == that.indexStartTimeMillis && this.indexEndTimeMillis == that.indexEndTimeMillis && Objects.equals(this.downsampleConfig, that.downsampleConfig) && Objects.equals(this.downsampleIndex, that.downsampleIndex) && Objects.equals(this.shardId.id(), that.shardId.id()) && Objects.equals(this.shardId.getIndexName(), that.shardId.getIndexName()) && Arrays.equals(this.metrics, that.metrics) && Arrays.equals(this.labels, that.labels) && Arrays.equals(this.dimensions, that.dimensions);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.downsampleConfig, this.downsampleIndex, this.indexStartTimeMillis, this.indexEndTimeMillis, this.shardId.id(), this.shardId.getIndexName());
        result = 31 * result + Arrays.hashCode(this.metrics);
        result = 31 * result + Arrays.hashCode(this.labels);
        result = 31 * result + Arrays.hashCode(this.dimensions);
        return result;
    }

    @Override
    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    static {
        PARSER.declareObject(Builder::downsampleConfig, (p, c) -> DownsampleConfig.fromXContent((XContentParser)p), DOWNSAMPLE_CONFIG);
        PARSER.declareString(Builder::downsampleIndex, DOWNSAMPLE_INDEX);
        PARSER.declareLong(Builder::indexStartTimeMillis, INDEX_START_TIME_MILLIS);
        PARSER.declareLong(Builder::indexEndTimeMillis, INDEX_END_TIME_MILLIS);
        PARSER.declareString(Builder::shardId, SHARD_ID);
        PARSER.declareStringArray(Builder::metrics, METRICS);
        PARSER.declareStringArray(Builder::labels, LABELS);
        PARSER.declareStringArray(Builder::dimensions, DIMENSIONS);
    }

    public static class Builder {
        DownsampleConfig downsampleConfig;
        String downsampleIndex;
        long indexStartTimeMillis;
        long indexEndTimeMillis;
        ShardId shardId;
        String[] metrics;
        String[] labels;
        String[] dimensions = Strings.EMPTY_ARRAY;

        public Builder downsampleConfig(DownsampleConfig downsampleConfig) {
            this.downsampleConfig = downsampleConfig;
            return this;
        }

        public Builder downsampleIndex(String downsampleIndex) {
            this.downsampleIndex = downsampleIndex;
            return this;
        }

        public Builder indexStartTimeMillis(Long indexStartTimeMillis) {
            this.indexStartTimeMillis = indexStartTimeMillis;
            return this;
        }

        public Builder indexEndTimeMillis(Long indexEndTimeMillis) {
            this.indexEndTimeMillis = indexEndTimeMillis;
            return this;
        }

        public Builder shardId(String shardId) {
            this.shardId = ShardId.fromString((String)shardId);
            return this;
        }

        public Builder metrics(List<String> metrics) {
            this.metrics = (String[])metrics.toArray(String[]::new);
            return this;
        }

        public Builder labels(List<String> labels) {
            this.labels = (String[])labels.toArray(String[]::new);
            return this;
        }

        public Builder dimensions(List<String> dimensions) {
            this.dimensions = (String[])dimensions.toArray(String[]::new);
            return this;
        }

        public DownsampleShardTaskParams build() {
            return new DownsampleShardTaskParams(this.downsampleConfig, this.downsampleIndex, this.indexStartTimeMillis, this.indexEndTimeMillis, this.shardId, this.metrics, this.labels, this.dimensions);
        }
    }
}

