/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.telemetry.metric.MeterRegistry;

public class DownsampleMetrics
extends AbstractLifecycleComponent {
    public static final String LATENCY_SHARD = "es.tsdb.downsample.latency.shard.histogram";
    public static final String LATENCY_TOTAL = "es.tsdb.downsample.latency.total.histogram";
    public static final String ACTIONS_SHARD = "es.tsdb.downsample.actions.shard.total";
    public static final String ACTIONS = "es.tsdb.downsample.actions.total";
    private final MeterRegistry meterRegistry;

    public DownsampleMetrics(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    protected void doStart() {
        this.meterRegistry.registerLongHistogram(LATENCY_SHARD, "Downsampling action latency per shard", "ms");
        this.meterRegistry.registerLongHistogram(LATENCY_TOTAL, "Downsampling latency end-to-end", "ms");
        this.meterRegistry.registerLongCounter(ACTIONS_SHARD, "Number of shard-level downsampling actions", "count");
        this.meterRegistry.registerLongCounter(ACTIONS, "Number of downsampling operations", "count");
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }

    void recordShardOperation(long durationInMilliSeconds, ActionStatus status) {
        this.meterRegistry.getLongHistogram(LATENCY_SHARD).record(durationInMilliSeconds, Map.of("status", status.getMessage()));
        this.meterRegistry.getLongCounter(ACTIONS_SHARD).incrementBy(1L, Map.of("status", status.getMessage()));
    }

    void recordOperation(long durationInMilliSeconds, ActionStatus status) {
        this.meterRegistry.getLongHistogram(LATENCY_TOTAL).record(durationInMilliSeconds, Map.of("status", status.getMessage()));
        this.meterRegistry.getLongCounter(ACTIONS).incrementBy(1L, Map.of("status", status.getMessage()));
    }

    static enum ActionStatus {
        SUCCESS("success"),
        MISSING_DOCS("missing_docs"),
        FAILED("failed"),
        INVALID_CONFIGURATION("invalid_configuration");

        static final String NAME = "status";
        private final String message;

        private ActionStatus(String message) {
            this.message = message;
        }

        String getMessage() {
            return this.message;
        }
    }
}

