/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.downsample;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.downsample.AbstractDownsampleFieldProducer;

public class DimensionFieldProducer
extends AbstractDownsampleFieldProducer {
    private final Dimension dimension;

    DimensionFieldProducer(String name, Dimension dimension) {
        super(name);
        this.dimension = dimension;
    }

    @Override
    public void reset() {
        this.dimension.reset();
    }

    @Override
    public boolean isEmpty() {
        return this.dimension.isEmpty;
    }

    @Override
    public void collect(FormattedDocValues docValues, int docId) throws IOException {
        if (!docValues.advanceExact(docId)) {
            return;
        }
        int docValueCount = docValues.docValueCount();
        for (int i = 0; i < docValueCount; ++i) {
            this.dimension.collect(docValues.nextValue());
        }
    }

    @Override
    public void write(XContentBuilder builder) throws IOException {
        if (!this.isEmpty()) {
            builder.field(this.dimension.name, this.dimension.value());
        }
    }

    static class Dimension {
        private final String name;
        private Object value;
        private boolean isEmpty;

        Dimension(String name) {
            this.name = name;
            this.isEmpty = true;
        }

        public Object value() {
            return this.value;
        }

        public String name() {
            return this.name;
        }

        void reset() {
            this.value = null;
            this.isEmpty = true;
        }

        void collect(Object value) {
            Objects.requireNonNull(value);
            if (this.isEmpty) {
                this.value = value;
                this.isEmpty = false;
                return;
            }
            if (!value.equals(this.value)) {
                throw new IllegalArgumentException("Dimension value changed without tsid change [" + value + "] != [" + this.value + "]");
            }
        }
    }
}

