/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.RemoteClusterActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.action.repositories.GetCcrRestoreFileChunkRequest;
import org.elasticsearch.xpack.ccr.repository.CcrRestoreSourceService;

public class GetCcrRestoreFileChunkAction
extends ActionType<GetCcrRestoreFileChunkResponse> {
    public static final GetCcrRestoreFileChunkAction INTERNAL_INSTANCE = new GetCcrRestoreFileChunkAction();
    public static final String INTERNAL_NAME = "internal:admin/ccr/restore/file_chunk/get";
    public static final String NAME = "indices:internal/admin/ccr/restore/file_chunk/get";
    public static final GetCcrRestoreFileChunkAction INSTANCE = new GetCcrRestoreFileChunkAction("indices:internal/admin/ccr/restore/file_chunk/get");
    public static final RemoteClusterActionType<GetCcrRestoreFileChunkResponse> REMOTE_TYPE = new RemoteClusterActionType("indices:internal/admin/ccr/restore/file_chunk/get", GetCcrRestoreFileChunkResponse::new);
    public static final RemoteClusterActionType<GetCcrRestoreFileChunkResponse> REMOTE_INTERNAL_TYPE = new RemoteClusterActionType("internal:admin/ccr/restore/file_chunk/get", GetCcrRestoreFileChunkResponse::new);

    private GetCcrRestoreFileChunkAction() {
        this(INTERNAL_NAME);
    }

    private GetCcrRestoreFileChunkAction(String name) {
        super(name);
    }

    public static class GetCcrRestoreFileChunkResponse
    extends ActionResponse {
        private final long offset;
        private final ReleasableBytesReference chunk;

        GetCcrRestoreFileChunkResponse(StreamInput streamInput) throws IOException {
            super(streamInput);
            assert (ThreadPool.assertCurrentThreadPool((String[])new String[]{"generic"}));
            this.offset = streamInput.readVLong();
            this.chunk = streamInput.readReleasableBytesReference();
        }

        GetCcrRestoreFileChunkResponse(long offset, ReleasableBytesReference chunk) {
            this.offset = offset;
            this.chunk = chunk.retain();
        }

        public long getOffset() {
            return this.offset;
        }

        public ReleasableBytesReference getChunk() {
            return this.chunk;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.offset);
            out.writeBytesReference((BytesReference)this.chunk);
        }

        public void incRef() {
            this.chunk.incRef();
        }

        public boolean tryIncRef() {
            return this.chunk.tryIncRef();
        }

        public boolean decRef() {
            return this.chunk.decRef();
        }

        public boolean hasReferences() {
            return this.chunk.hasReferences();
        }
    }

    public static class TransportAction
    extends TransportGetCcrRestoreFileChunkAction {
        @Inject
        public TransportAction(BigArrays bigArrays, TransportService transportService, ActionFilters actionFilters, CcrRestoreSourceService restoreSourceService) {
            super(GetCcrRestoreFileChunkAction.NAME, bigArrays, transportService, actionFilters, restoreSourceService);
        }

        @Override
        protected void validate(GetCcrRestoreFileChunkRequest request) {
            ShardId shardId = request.getShardId();
            assert (shardId != null) : "shardId must be specified for the request";
            this.restoreSourceService.ensureSessionShardIdConsistency(request.getSessionUUID(), shardId);
            this.restoreSourceService.ensureFileNameIsKnownToSession(request.getSessionUUID(), request.getFileName());
        }
    }

    public static class InternalTransportAction
    extends TransportGetCcrRestoreFileChunkAction {
        @Inject
        public InternalTransportAction(BigArrays bigArrays, TransportService transportService, ActionFilters actionFilters, CcrRestoreSourceService restoreSourceService) {
            super(GetCcrRestoreFileChunkAction.INTERNAL_NAME, bigArrays, transportService, actionFilters, restoreSourceService);
        }
    }

    static abstract class TransportGetCcrRestoreFileChunkAction
    extends HandledTransportAction<GetCcrRestoreFileChunkRequest, GetCcrRestoreFileChunkResponse> {
        protected final CcrRestoreSourceService restoreSourceService;
        private final BigArrays bigArrays;

        private TransportGetCcrRestoreFileChunkAction(String actionName, BigArrays bigArrays, TransportService transportService, ActionFilters actionFilters, CcrRestoreSourceService restoreSourceService) {
            super(actionName, transportService, actionFilters, GetCcrRestoreFileChunkRequest::new, (Executor)transportService.getThreadPool().executor("generic"));
            TransportActionProxy.registerProxyAction((TransportService)transportService, (String)actionName, (boolean)false, GetCcrRestoreFileChunkResponse::new);
            this.restoreSourceService = restoreSourceService;
            this.bigArrays = bigArrays;
        }

        protected void doExecute(Task task, GetCcrRestoreFileChunkRequest request, ActionListener<GetCcrRestoreFileChunkResponse> listener) {
            this.validate(request);
            int bytesRequested = request.getSize();
            ByteArray array = this.bigArrays.newByteArray((long)bytesRequested, false);
            String fileName = request.getFileName();
            String sessionUUID = request.getSessionUUID();
            BytesReference pagedBytesReference = BytesReference.fromByteArray((ByteArray)array, (int)bytesRequested);
            try (ReleasableBytesReference reference = new ReleasableBytesReference(pagedBytesReference, (Releasable)array);
                 CcrRestoreSourceService.SessionReader sessionReader = this.restoreSourceService.getSessionReader(sessionUUID);){
                long offsetAfterRead = sessionReader.readFileBytes(fileName, (BytesReference)reference);
                long offsetBeforeRead = offsetAfterRead - (long)reference.length();
                ActionListener.respondAndRelease(listener, (RefCounted)new GetCcrRestoreFileChunkResponse(offsetBeforeRead, reference));
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
            }
        }

        protected void validate(GetCcrRestoreFileChunkRequest request) {
        }
    }
}

