/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreClusterStateListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.ccr.action.TransportResumeFollowAction;
import org.elasticsearch.xpack.core.ccr.action.FollowParameters;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;

public final class TransportPutFollowAction
extends TransportMasterNodeAction<PutFollowAction.Request, PutFollowAction.Response> {
    private static final Logger logger = LogManager.getLogger(TransportPutFollowAction.class);
    private final IndexScopedSettings indexScopedSettings;
    private final Client client;
    private final Executor remoteClientResponseExecutor;
    private final RestoreService restoreService;
    private final CcrLicenseChecker ccrLicenseChecker;

    @Inject
    public TransportPutFollowAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, IndexScopedSettings indexScopedSettings, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, RestoreService restoreService, CcrLicenseChecker ccrLicenseChecker) {
        super("indices:admin/xpack/ccr/put_follow", transportService, clusterService, threadPool, actionFilters, PutFollowAction.Request::new, indexNameExpressionResolver, PutFollowAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.indexScopedSettings = indexScopedSettings;
        this.client = client;
        this.remoteClientResponseExecutor = threadPool.executor("ccr");
        this.restoreService = restoreService;
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker);
    }

    protected void masterOperation(Task task, PutFollowAction.Request request, ClusterState state, ActionListener<PutFollowAction.Response> listener) {
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        String remoteCluster = request.getRemoteCluster();
        this.client.getRemoteClusterClient(remoteCluster, this.remoteClientResponseExecutor, RemoteClusterService.DisconnectedStrategy.RECONNECT_IF_DISCONNECTED);
        String leaderIndex = request.getLeaderIndex();
        this.ccrLicenseChecker.checkRemoteClusterLicenseAndFetchLeaderIndexMetadataAndHistoryUUIDs(this.client, remoteCluster, leaderIndex, arg_0 -> listener.onFailure(arg_0), (historyUUID, tuple) -> this.createFollowerIndex((IndexMetadata)tuple.v1(), (DataStream)tuple.v2(), request, listener));
    }

    private void createFollowerIndex(IndexMetadata leaderIndexMetadata, DataStream remoteDataStream, PutFollowAction.Request request, ActionListener<PutFollowAction.Response> listener) {
        if (leaderIndexMetadata == null) {
            listener.onFailure((Exception)new IllegalArgumentException("leader index [" + request.getLeaderIndex() + "] does not exist"));
            return;
        }
        if (!((Boolean)IndexSettings.INDEX_SOFT_DELETES_SETTING.get(leaderIndexMetadata.getSettings())).booleanValue()) {
            listener.onFailure((Exception)new IllegalArgumentException("leader index [" + request.getLeaderIndex() + "] does not have soft deletes enabled"));
            return;
        }
        if (leaderIndexMetadata.isSearchableSnapshot()) {
            listener.onFailure((Exception)new IllegalArgumentException("leader index [" + request.getLeaderIndex() + "] is a searchable snapshot index and cannot be used as a leader index for cross-cluster replication purpose"));
            return;
        }
        Settings replicatedRequestSettings = TransportResumeFollowAction.filter(request.getSettings());
        if (!replicatedRequestSettings.isEmpty()) {
            List unknownKeys = replicatedRequestSettings.keySet().stream().filter(s -> this.indexScopedSettings.get(s) == null).collect(Collectors.toList());
            String message = unknownKeys.isEmpty() ? String.format(Locale.ROOT, "can not put follower index that could override leader settings %s", replicatedRequestSettings) : String.format(Locale.ROOT, "unknown setting%s [%s]", unknownKeys.size() == 1 ? "" : "s", String.join((CharSequence)",", unknownKeys));
            listener.onFailure((Exception)new IllegalArgumentException(message));
            return;
        }
        Settings overrideSettings = Settings.builder().put("index.provided_name", request.getFollowerIndex()).put(CcrSettings.CCR_FOLLOWING_INDEX_SETTING.getKey(), true).put(request.getSettings()).build();
        String leaderClusterRepoName = "_ccr_" + request.getRemoteCluster();
        RestoreSnapshotRequest restoreRequest = ((RestoreSnapshotRequest)new RestoreSnapshotRequest(leaderClusterRepoName, "_latest_").indices(new String[]{request.getLeaderIndex()}).indicesOptions(request.indicesOptions()).renamePattern("^(.*)$").renameReplacement(Matcher.quoteReplacement(request.getFollowerIndex())).masterNodeTimeout(request.masterNodeTimeout())).indexSettings(overrideSettings).quiet(true);
        Client clientWithHeaders = CcrLicenseChecker.wrapClient(this.client, this.threadPool.getThreadContext().getHeaders(), this.clusterService.state());
        ActionListener delegatelistener = listener.delegateFailure((delegatedListener, response) -> this.afterRestoreStarted(clientWithHeaders, request, (ActionListener<PutFollowAction.Response>)delegatedListener, (RestoreService.RestoreCompletionResponse)response));
        if (remoteDataStream == null) {
            this.restoreService.restoreSnapshot(restoreRequest, delegatelistener);
        } else {
            String followerIndexName = request.getFollowerIndex();
            BiConsumer<ClusterState, Metadata.Builder> updater = (currentState, mdBuilder) -> {
                String dsName = request.getDataStreamName();
                String localDataStreamName = Strings.hasText((String)dsName) ? dsName : remoteDataStream.getName();
                DataStream localDataStream = (DataStream)mdBuilder.dataStreamMetadata().dataStreams().get(localDataStreamName);
                Index followerIndex = mdBuilder.get(followerIndexName).getIndex();
                assert (followerIndex != null) : "expected followerIndex " + followerIndexName + " to exist in the state, but it did not";
                DataStream updatedDataStream = TransportPutFollowAction.updateLocalDataStream(followerIndex, localDataStream, localDataStreamName, remoteDataStream);
                mdBuilder.put(updatedDataStream);
            };
            this.restoreService.restoreSnapshot(restoreRequest, delegatelistener, updater);
        }
    }

    private void afterRestoreStarted(Client clientWithHeaders, final PutFollowAction.Request request, ActionListener<PutFollowAction.Response> originalListener, RestoreService.RestoreCompletionResponse response) {
        ActionListener<PutFollowAction.Response> listener;
        if (ActiveShardCount.NONE.equals((Object)request.waitForActiveShards())) {
            originalListener.onResponse((Object)new PutFollowAction.Response(true, false, false));
            listener = new ActionListener<PutFollowAction.Response>(){

                public void onResponse(PutFollowAction.Response response) {
                    logger.debug("put follow {} completed with {}", (Object)request, (Object)response);
                }

                public void onFailure(Exception e) {
                    logger.debug(() -> "put follow " + request + " failed during the restore process", (Throwable)e);
                }
            };
        } else {
            listener = originalListener;
        }
        RestoreClusterStateListener.createAndRegisterListener((ClusterService)this.clusterService, (RestoreService.RestoreCompletionResponse)response, (ActionListener)listener.delegateFailure((delegatedListener, restoreSnapshotResponse) -> {
            RestoreInfo restoreInfo = restoreSnapshotResponse.getRestoreInfo();
            if (restoreInfo == null) {
                delegatedListener.onResponse((Object)new PutFollowAction.Response(true, false, false));
            } else if (restoreInfo.failedShards() == 0) {
                this.initiateFollowing(clientWithHeaders, request, (ActionListener<PutFollowAction.Response>)delegatedListener);
            } else {
                assert (restoreInfo.failedShards() > 0) : "Should have failed shards";
                delegatedListener.onResponse((Object)new PutFollowAction.Response(true, false, false));
            }
        }), (ThreadContext)this.threadPool.getThreadContext());
    }

    private void initiateFollowing(Client clientWithHeaders, PutFollowAction.Request request, ActionListener<PutFollowAction.Response> listener) {
        assert (request.waitForActiveShards() != ActiveShardCount.DEFAULT) : "PutFollowAction does not support DEFAULT.";
        FollowParameters parameters = request.getParameters();
        ResumeFollowAction.Request resumeFollowRequest = new ResumeFollowAction.Request();
        resumeFollowRequest.setFollowerIndex(request.getFollowerIndex());
        resumeFollowRequest.setParameters(new FollowParameters(parameters));
        resumeFollowRequest.masterNodeTimeout(request.masterNodeTimeout());
        clientWithHeaders.execute((ActionType)ResumeFollowAction.INSTANCE, (ActionRequest)resumeFollowRequest, listener.delegateFailureAndWrap((l, r) -> ActiveShardsObserver.waitForActiveShards((ClusterService)this.clusterService, (String[])new String[]{request.getFollowerIndex()}, (ActiveShardCount)request.waitForActiveShards(), (TimeValue)request.timeout(), (ActionListener)l.map(result -> new PutFollowAction.Response(true, result.booleanValue(), r.isAcknowledged())))));
    }

    static DataStream updateLocalDataStream(Index backingIndexToFollow, DataStream localDataStream, String localDataStreamName, DataStream remoteDataStream) {
        ArrayList<Index> backingIndices;
        if (localDataStream == null) {
            return remoteDataStream.copy().setName(localDataStreamName).setIndices(List.of(backingIndexToFollow)).setReplicated(true).setRolloverOnWrite(false).build();
        }
        if (!localDataStream.isReplicated()) {
            throw new IllegalArgumentException("cannot follow backing index [" + backingIndexToFollow.getName() + "], because local data stream [" + localDataStream.getName() + "] is no longer marked as replicated");
        }
        if (!localDataStream.getIndices().contains(backingIndexToFollow)) {
            backingIndices = new ArrayList<Index>(localDataStream.getIndices());
            backingIndices.add(backingIndexToFollow);
            String partitionByBackingIndexBaseName = ".ds-" + localDataStream.getName();
            backingIndices.sort(Comparator.comparing(o -> o.getName().contains(partitionByBackingIndexBaseName) ? 1 : -1).thenComparing(o -> {
                int backingPrefixPosition = o.getName().indexOf(".ds-");
                return backingPrefixPosition > -1 ? o.getName().substring(backingPrefixPosition) : o.getName();
            }));
        } else {
            backingIndices = localDataStream.getIndices();
        }
        return localDataStream.copy().setIndices(backingIndices).setGeneration(remoteDataStream.getGeneration()).setMetadata(remoteDataStream.getMetadata()).build();
    }

    protected ClusterBlockException checkBlock(PutFollowAction.Request request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.getFollowerIndex());
    }
}

