/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;

final class ResponseHandler {
    private final AtomicInteger counter;
    private final AtomicReferenceArray<Object> responses;
    private final ActionListener<AcknowledgedResponse> listener;

    ResponseHandler(int numRequests, ActionListener<AcknowledgedResponse> listener) {
        this.counter = new AtomicInteger(numRequests);
        this.responses = new AtomicReferenceArray(numRequests);
        this.listener = listener;
    }

    <T> ActionListener<T> getActionListener(final int requestId) {
        return new ActionListener<T>(){

            public void onResponse(T response) {
                ResponseHandler.this.responses.set(requestId, response);
                ResponseHandler.this.finalizeResponse();
            }

            public void onFailure(Exception e) {
                ResponseHandler.this.responses.set(requestId, e);
                ResponseHandler.this.finalizeResponse();
            }
        };
    }

    private void finalizeResponse() {
        Exception error = null;
        if (this.counter.decrementAndGet() == 0) {
            for (int j = 0; j < this.responses.length(); ++j) {
                Object response = this.responses.get(j);
                if (!(response instanceof Exception)) continue;
                if (error == null) {
                    error = (Exception)response;
                    continue;
                }
                error.addSuppressed((Exception)response);
            }
            if (error == null) {
                this.listener.onResponse((Object)AcknowledgedResponse.TRUE);
            } else {
                this.listener.onFailure(error);
            }
        }
    }
}

