/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr;

import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.seqno.RetentionLeaseActions;
import org.elasticsearch.index.seqno.RetentionLeaseAlreadyExistsException;
import org.elasticsearch.index.seqno.RetentionLeaseNotFoundException;
import org.elasticsearch.index.shard.ShardId;

public class CcrRetentionLeases {
    public static final Setting<TimeValue> RETENTION_LEASE_RENEW_INTERVAL_SETTING = Setting.timeSetting((String)"index.ccr.retention_lease.renew_interval", (TimeValue)new TimeValue(30L, TimeUnit.SECONDS), (TimeValue)new TimeValue(0L, TimeUnit.MILLISECONDS), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    public static String retentionLeaseId(String localClusterName, Index followerIndex, String remoteClusterAlias, Index leaderIndex) {
        return String.format(Locale.ROOT, "%s/%s/%s-following-%s/%s/%s", localClusterName, followerIndex.getName(), followerIndex.getUUID(), remoteClusterAlias, leaderIndex.getName(), leaderIndex.getUUID());
    }

    public static Optional<RetentionLeaseAlreadyExistsException> syncAddRetentionLease(ShardId leaderShardId, String retentionLeaseId, long retainingSequenceNumber, RemoteClusterClient remoteClient, TimeValue timeout) {
        try {
            PlainActionFuture response = new PlainActionFuture();
            CcrRetentionLeases.asyncAddRetentionLease(leaderShardId, retentionLeaseId, retainingSequenceNumber, remoteClient, (ActionListener<ActionResponse.Empty>)response);
            response.actionGet(timeout);
            return Optional.empty();
        }
        catch (RetentionLeaseAlreadyExistsException e) {
            return Optional.of(e);
        }
    }

    public static void asyncAddRetentionLease(ShardId leaderShardId, String retentionLeaseId, long retainingSequenceNumber, RemoteClusterClient remoteClient, ActionListener<ActionResponse.Empty> listener) {
        RetentionLeaseActions.AddRequest request = new RetentionLeaseActions.AddRequest(leaderShardId, retentionLeaseId, retainingSequenceNumber, "ccr");
        remoteClient.execute(RetentionLeaseActions.REMOTE_ADD, (ActionRequest)request, listener);
    }

    public static Optional<RetentionLeaseNotFoundException> syncRenewRetentionLease(ShardId leaderShardId, String retentionLeaseId, long retainingSequenceNumber, RemoteClusterClient remoteClient, TimeValue timeout) {
        try {
            PlainActionFuture response = new PlainActionFuture();
            CcrRetentionLeases.asyncRenewRetentionLease(leaderShardId, retentionLeaseId, retainingSequenceNumber, remoteClient, (ActionListener<ActionResponse.Empty>)response);
            response.actionGet(timeout);
            return Optional.empty();
        }
        catch (RetentionLeaseNotFoundException e) {
            return Optional.of(e);
        }
    }

    public static void asyncRenewRetentionLease(ShardId leaderShardId, String retentionLeaseId, long retainingSequenceNumber, RemoteClusterClient remoteClient, ActionListener<ActionResponse.Empty> listener) {
        RetentionLeaseActions.RenewRequest request = new RetentionLeaseActions.RenewRequest(leaderShardId, retentionLeaseId, retainingSequenceNumber, "ccr");
        remoteClient.execute(RetentionLeaseActions.REMOTE_RENEW, (ActionRequest)request, listener);
    }

    public static void asyncRemoveRetentionLease(ShardId leaderShardId, String retentionLeaseId, RemoteClusterClient remoteClient, ActionListener<ActionResponse.Empty> listener) {
        RetentionLeaseActions.RemoveRequest request = new RetentionLeaseActions.RemoveRequest(leaderShardId, retentionLeaseId);
        remoteClient.execute(RetentionLeaseActions.REMOTE_REMOVE, (ActionRequest)request, listener);
    }
}

