/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.windows.service;

import java.nio.file.Path;
import java.util.List;
import joptsimple.OptionSet;
import org.elasticsearch.bootstrap.ServerArgs;
import org.elasticsearch.cli.ProcessInfo;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.common.cli.EnvironmentAwareCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.SecureSettings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.env.Environment;
import org.elasticsearch.server.cli.JvmOptionsParser;
import org.elasticsearch.server.cli.ServerProcess;
import org.elasticsearch.server.cli.ServerProcessBuilder;
import org.elasticsearch.server.cli.ServerProcessUtils;

class WindowsServiceDaemon
extends EnvironmentAwareCommand {
    private volatile ServerProcess server;

    WindowsServiceDaemon() {
        super("Starts and stops the Elasticsearch server process for a Windows Service");
    }

    public void execute(Terminal terminal, OptionSet options, Environment env, ProcessInfo processInfo) throws Exception {
        try (KeyStoreWrapper loadedSecrets = KeyStoreWrapper.bootstrap((Path)env.configFile(), () -> new SecureString(new char[0]));){
            ServerArgs args = new ServerArgs(false, true, null, (SecureSettings)loadedSecrets, env.settings(), env.configFile(), env.logsFile());
            Path tempDir = ServerProcessUtils.setupTempDir((ProcessInfo)processInfo);
            List jvmOptions = JvmOptionsParser.determineJvmOptions((ServerArgs)args, (ProcessInfo)processInfo, (Path)tempDir);
            ServerProcessBuilder serverProcessBuilder = new ServerProcessBuilder().withTerminal(terminal).withProcessInfo(processInfo).withServerArgs(args).withTempDir(tempDir).withJvmOptions(jvmOptions);
            this.server = serverProcessBuilder.start();
        }
    }

    public void close() {
        if (this.server != null) {
            this.server.stop();
        }
    }
}

