/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.esql.enrich.EnrichPolicyResolution;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.ql.capabilities.Resolvables;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.EmptyAttribute;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.NamedExpression;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class Enrich
extends UnaryPlan {
    private final Expression policyName;
    private final NamedExpression matchField;
    private final EnrichPolicyResolution policy;
    private List<NamedExpression> enrichFields;
    private List<Attribute> output;

    public Enrich(Source source, LogicalPlan child, Expression policyName, NamedExpression matchField, EnrichPolicyResolution policy, List<NamedExpression> enrichFields) {
        super(source, child);
        this.policyName = policyName;
        this.matchField = matchField;
        this.policy = policy;
        this.enrichFields = enrichFields;
    }

    public NamedExpression matchField() {
        return this.matchField;
    }

    public List<NamedExpression> enrichFields() {
        return this.enrichFields;
    }

    public EnrichPolicyResolution policy() {
        return this.policy;
    }

    public Expression policyName() {
        return this.policyName;
    }

    public boolean expressionsResolved() {
        return this.policyName.resolved() && !(this.matchField instanceof EmptyAttribute) && this.matchField.resolved() && Resolvables.resolved(this.enrichFields());
    }

    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Enrich(this.source(), newChild, this.policyName, this.matchField, this.policy, this.enrichFields);
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Enrich::new, (Object)this.child(), (Object)this.policyName, (Object)this.matchField, (Object)this.policy, this.enrichFields);
    }

    public List<Attribute> output() {
        if (this.enrichFields == null) {
            return this.child().output();
        }
        if (this.output == null) {
            this.output = NamedExpressions.mergeOutputAttributes(this.enrichFields(), this.child().output());
        }
        return this.output;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Enrich enrich = (Enrich)((Object)o);
        return Objects.equals(this.policyName, enrich.policyName) && Objects.equals(this.matchField, enrich.matchField) && Objects.equals(this.policy, enrich.policy) && Objects.equals(this.enrichFields, enrich.enrichFields);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.policyName, this.matchField, this.policy, this.enrichFields);
    }
}

