/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.esql.io.stream.PlanNamedTypes;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;

public class PlanNameRegistry {
    public static final PlanNameRegistry INSTANCE = new PlanNameRegistry();
    private final Map<Class<?>, Map<String, PlanReader<?>>> readerRegistry;
    private final Map<Class<?>, Map<String, PlanWriter<?>>> writerRegistry;

    public PlanNameRegistry() {
        this(PlanNamedTypes.namedTypeEntries());
    }

    PlanNameRegistry(List<Entry> entries) {
        Map writers;
        Map readers;
        entries = new ArrayList<Entry>(entries);
        entries.sort(Comparator.comparing(e -> e.categoryClass().getName()));
        HashMap<Class, Map> rr = new HashMap<Class, Map>();
        HashMap<Class, Map> wr = new HashMap<Class, Map>();
        for (Entry entry : entries) {
            PlanWriter<?> oldWriter;
            Class<?> categoryClass = entry.categoryClass;
            readers = rr.computeIfAbsent(categoryClass, v -> new HashMap());
            writers = wr.computeIfAbsent(categoryClass, v -> new HashMap());
            PlanReader<?> oldReader = readers.put(entry.name, entry.reader);
            if (oldReader != null) {
                PlanNameRegistry.throwAlreadyRegisteredReader(categoryClass, entry.name, oldReader.getClass(), entry.reader.getClass());
            }
            if ((oldWriter = writers.put(entry.name, entry.writer)) == null) continue;
            PlanNameRegistry.throwAlreadyRegisteredReader(categoryClass, entry.name, oldWriter.getClass(), entry.writer.getClass());
        }
        Map<Class<?>, List<Class<?>>> subCategories = PlanNameRegistry.subCategories(entries);
        for (Map.Entry<Class<?>, List<Class<?>>> entry : subCategories.entrySet()) {
            readers = (Map)rr.get(entry.getKey());
            writers = (Map)wr.get(entry.getKey());
            for (Class<?> subCategory : entry.getValue()) {
                readers.putAll((Map)rr.get(subCategory));
                writers.putAll((Map)wr.get(subCategory));
            }
        }
        this.readerRegistry = Map.copyOf(rr);
        this.writerRegistry = Map.copyOf(wr);
    }

    static Map<Class<?>, List<Class<?>>> subCategories(List<Entry> entries) {
        HashMap<Class, Set> map = new HashMap<Class, Set>();
        for (Entry entry : entries) {
            Class<?> category = entry.categoryClass;
            for (Entry entry1 : entries) {
                Class<?> category1 = entry1.categoryClass;
                if (category == category1 || !category.isAssignableFrom(category1)) continue;
                Set set = map.computeIfAbsent(category, v -> new HashSet());
                set.add(category1);
            }
        }
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, s -> new ArrayList((Collection)s.getValue())));
    }

    <T> PlanReader<? extends T> getReader(Class<T> categoryClass, String name) {
        Map<String, PlanReader<?>> readers = this.getReaders(categoryClass);
        return PlanNameRegistry.getReader(categoryClass, name, readers);
    }

    static <T> PlanReader<? extends T> getReader(Class<T> categoryClass, String name, Map<String, PlanReader<?>> readers) {
        PlanReader<?> reader = readers.get(name);
        if (reader == null) {
            PlanNameRegistry.throwOnUnknownReadable(categoryClass, name);
        }
        return reader;
    }

    <T> Map<String, PlanReader<?>> getReaders(Class<T> categoryClass) {
        Map<String, PlanReader<?>> readers = this.readerRegistry.get(categoryClass);
        if (readers == null) {
            PlanNameRegistry.throwOnUnknownCategory(categoryClass);
        }
        return readers;
    }

    <T> PlanWriter<? extends T> getWriter(Class<T> categoryClass, String name, Map<String, PlanWriter<?>> writers) {
        PlanWriter<?> writer = writers.get(name);
        if (writer == null) {
            PlanNameRegistry.throwOnUnknownWritable(categoryClass, name);
        }
        return writer;
    }

    public <T> Map<String, PlanWriter<?>> getWriters(Class<T> categoryClass) {
        Map<String, PlanWriter<?>> writers = this.writerRegistry.get(categoryClass);
        if (writers == null) {
            PlanNameRegistry.throwOnUnknownCategory(categoryClass);
        }
        return writers;
    }

    public <T> PlanWriter<? extends T> getWriter(Class<T> categoryClass, String name) {
        Map<String, PlanWriter<?>> writers = this.getWriters(categoryClass);
        return this.getWriter(categoryClass, name, writers);
    }

    private static void throwAlreadyRegisteredReader(Class<?> categoryClass, String entryName, Class<?> oldReader, Class<?> entryReader) {
        throw new IllegalArgumentException("PlanReader [" + categoryClass.getName() + "][" + entryName + "] is already registered for [" + oldReader.getName() + "], cannot register [" + entryReader.getName() + "]");
    }

    private static <T> void throwOnUnknownWritable(Class<T> categoryClass, String name) {
        throw new IllegalArgumentException("Unknown writeable [" + categoryClass.getName() + "][" + name + "]");
    }

    private static <T> void throwOnUnknownCategory(Class<T> categoryClass) {
        throw new IllegalArgumentException("Unknown writeable category [" + categoryClass.getName() + "]");
    }

    private static <T> void throwOnUnknownReadable(Class<T> categoryClass, String name) {
        throw new IllegalArgumentException("Unknown readable [" + categoryClass.getName() + "][" + name + "]");
    }

    record Entry(Class<?> categoryClass, Class<?> concreteClass, String name, PlanWriter<?> writer, PlanReader<?> reader) {
        Entry {
            Objects.requireNonNull(categoryClass);
            Objects.requireNonNull(name);
            Objects.requireNonNull(writer);
            Objects.requireNonNull(reader);
        }

        static <T, C extends T, S extends T> Entry of(Class<T> categoryClass, Class<C> concreteClass, PlanWriter<S> writer, PlanReader<S> reader) {
            return new Entry(categoryClass, concreteClass, PlanNamedTypes.name(concreteClass), writer, reader);
        }

        static <T, C extends T, S extends T> Entry of(Class<T> categoryClass, Class<C> concreteClass, PlanWriter<S> writer, PlanNamedReader<S> reader) {
            return new Entry(categoryClass, concreteClass, PlanNamedTypes.name(concreteClass), writer, reader);
        }
    }

    @FunctionalInterface
    public static interface PlanReader<V>
    extends Writeable.Reader<V> {
        public V read(PlanStreamInput var1) throws IOException;

        default public V read(StreamInput in) throws IOException {
            return this.read((PlanStreamInput)in);
        }

        public static <V> Writeable.Reader<V> readerFromPlanReader(PlanReader<V> planReader) {
            return planReader;
        }
    }

    @FunctionalInterface
    public static interface PlanWriter<V>
    extends Writeable.Writer<V> {
        public void write(PlanStreamOutput var1, V var2) throws IOException;

        default public void write(StreamOutput out, V value) throws IOException {
            this.write((PlanStreamOutput)out, value);
        }

        public static <V> Writeable.Writer<V> writerFromPlanWriter(PlanWriter<V> planWriter) {
            return planWriter;
        }
    }

    @FunctionalInterface
    static interface PlanNamedReader<V>
    extends PlanReader<V> {
        public V read(PlanStreamInput var1, String var2) throws IOException;

        @Override
        default public V read(PlanStreamInput in) throws IOException {
            throw new UnsupportedOperationException("should not reach here");
        }
    }
}

