/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.formatter;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.xpack.esql.action.ColumnInfo;
import org.elasticsearch.xpack.esql.action.EsqlQueryResponse;

public class TextFormatter {
    private static final int MIN_COLUMN_WIDTH = 15;
    private final EsqlQueryResponse response;
    private final int[] width;
    private final Function<Object, String> FORMATTER = TextFormatter::formatEsqlResultObject;
    private static final String PADDING_64 = " ".repeat(64);

    public TextFormatter(EsqlQueryResponse response) {
        this.response = response;
        List<ColumnInfo> columns = response.columns();
        this.width = new int[columns.size()];
        for (int i = 0; i < this.width.length; ++i) {
            this.width[i] = Math.max(15, columns.get(i).name().length());
        }
        Iterator<Iterator<Object>> iterator = response.values();
        while (iterator.hasNext()) {
            Iterator<Object> row = iterator.next();
            for (int i = 0; i < this.width.length; ++i) {
                assert (row.hasNext());
                this.width[i] = Math.max(this.width[i], this.FORMATTER.apply(row.next()).length());
            }
            assert (!row.hasNext());
        }
    }

    public Iterator<CheckedConsumer<Writer, IOException>> format(boolean includeHeader) {
        return Iterators.concat((Iterator[])new Iterator[]{includeHeader && this.response.columns().size() > 0 ? Iterators.single(this::formatHeader) : Collections.emptyIterator(), this.formatResults()});
    }

    private void formatHeader(Writer writer) throws IOException {
        int i;
        for (i = 0; i < this.width.length; ++i) {
            if (i > 0) {
                writer.append('|');
            }
            String name = this.response.columns().get(i).name();
            int leftPadding = (this.width[i] - name.length()) / 2;
            TextFormatter.writePadding(leftPadding, writer);
            writer.append(name);
            TextFormatter.writePadding(this.width[i] - name.length() - leftPadding, writer);
        }
        writer.append('\n');
        for (i = 0; i < this.width.length; ++i) {
            if (i > 0) {
                writer.append('+');
            }
            writer.append("-".repeat(Math.max(0, this.width[i])));
        }
        writer.append('\n');
    }

    private Iterator<CheckedConsumer<Writer, IOException>> formatResults() {
        return Iterators.map(this.response.values(), row -> writer -> {
            for (int i = 0; i < this.width.length; ++i) {
                String string;
                assert (row.hasNext());
                if (i > 0) {
                    writer.append('|');
                }
                if ((string = this.FORMATTER.apply(row.next())).length() <= this.width[i]) {
                    writer.append(string);
                    TextFormatter.writePadding(this.width[i] - string.length(), writer);
                    continue;
                }
                writer.append(string, 0, this.width[i] - 1);
                writer.append('~');
            }
            assert (!row.hasNext());
            writer.append('\n');
        });
    }

    private static void writePadding(int padding, Writer writer) throws IOException {
        while (padding > PADDING_64.length()) {
            writer.append(PADDING_64);
            padding -= PADDING_64.length();
        }
        if (padding > 0) {
            writer.append(PADDING_64, 0, padding);
        }
    }

    private static String formatEsqlResultObject(Object obj) {
        if (obj instanceof SpatialPoint) {
            SpatialPoint point = (SpatialPoint)obj;
            return String.format(Locale.ROOT, "POINT (%.7f %.7f)", point.getX(), point.getY());
        }
        return Objects.toString(obj);
    }
}

