/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic;

import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Add;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.DateTimeArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.SubDatetimesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.SubDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.SubIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.SubLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.SubUnsignedLongsEvaluator;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.BinaryComparisonInversible;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.DateUtils;
import org.elasticsearch.xpack.ql.util.NumericUtils;

public class Sub
extends DateTimeArithmeticOperation
implements BinaryComparisonInversible {
    public Sub(Source source, Expression left, Expression right) {
        super(source, left, right, EsqlArithmeticOperation.OperationSymbol.SUB, SubIntsEvaluator.Factory::new, SubLongsEvaluator.Factory::new, SubUnsignedLongsEvaluator.Factory::new, (s, lhs, rhs) -> new SubDoublesEvaluator.Factory(source, lhs, rhs), SubDatetimesEvaluator.Factory::new);
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        Expression.TypeResolution resolution = super.resolveType();
        if (resolution.resolved() && EsqlDataTypes.isDateTimeOrTemporal(this.dataType()) && DataTypes.isDateTime((DataType)this.right().dataType())) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"[{}] arguments are in unsupported order: cannot subtract a [{}] value [{}] from a [{}] amount [{}]", (Object[])new Object[]{this.symbol(), this.right().dataType(), this.right().sourceText(), this.left().dataType(), this.left().sourceText()}));
        }
        return resolution;
    }

    protected NodeInfo<Sub> info() {
        return NodeInfo.create((Node)this, Sub::new, (Object)this.left(), (Object)this.right());
    }

    protected Sub replaceChildren(Expression left, Expression right) {
        return new Sub(this.source(), left, right);
    }

    public BinaryComparisonInversible.ArithmeticOperationFactory binaryComparisonInverse() {
        return Add::new;
    }

    static int processInts(int lhs, int rhs) {
        return Math.subtractExact(lhs, rhs);
    }

    static long processLongs(long lhs, long rhs) {
        return Math.subtractExact(lhs, rhs);
    }

    static long processUnsignedLongs(long lhs, long rhs) {
        return NumericUtils.unsignedLongSubtractExact((long)lhs, (long)rhs);
    }

    static double processDoubles(double lhs, double rhs) {
        return lhs - rhs;
    }

    static long processDatetimes(long datetime, TemporalAmount temporalAmount) {
        return DateUtils.asMillis((ZonedDateTime)DateUtils.asDateTime((long)datetime).minus(temporalAmount));
    }

    @Override
    public Period fold(Period left, Period right) {
        return left.minus(right);
    }

    @Override
    public Duration fold(Duration left, Duration right) {
        return left.minus(right);
    }
}

