/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.IsNaNEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.RationalUnaryPredicate;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class IsNaN
extends RationalUnaryPredicate {
    @FunctionInfo(returnType={"boolean"}, description="Returns true if the argument is a Not-a-Number (NaN) value.")
    public IsNaN(Source source, @Param(name="n", type={"double"}, description="A floating-point value") Expression field) {
        super(source, field);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return new IsNaNEvaluator.Factory(this.source(), toEvaluator.apply(this.field()));
    }

    static boolean process(double val) {
        return Double.isNaN(val);
    }

    public final Expression replaceChildren(List<Expression> newChildren) {
        return new IsNaN(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, IsNaN::new, (Object)this.field());
    }
}

