/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.List;
import java.util.function.Function;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.CeilDoubleEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;

public class Ceil
extends UnaryScalarFunction
implements EvaluatorMapper {
    public Ceil(Source source, @Param(name="n", type={"integer", "long", "double", "unsigned_long"}) Expression n) {
        super(source, n);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        if (this.dataType().isInteger()) {
            return toEvaluator.apply(this.field());
        }
        EvalOperator.ExpressionEvaluator.Factory fieldEval = toEvaluator.apply(this.field());
        return new CeilDoubleEvaluator.Factory(this.source(), fieldEval);
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isNumeric((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Ceil(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Ceil::new, (Object)this.field());
    }

    static double process(double val) {
        return Math.ceil(val);
    }
}

