/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTrunc;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Floor;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Div;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.Mul;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class AutoBucket
extends ScalarFunction
implements EvaluatorMapper {
    private static final Rounding LARGEST_HUMAN_DATE_ROUNDING = Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.YEAR_OF_CENTURY).build();
    private static final Rounding[] HUMAN_DATE_ROUNDINGS = new Rounding[]{Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.MONTH_OF_YEAR).build(), Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.WEEK_OF_WEEKYEAR).build(), Rounding.builder((Rounding.DateTimeUnit)Rounding.DateTimeUnit.DAY_OF_MONTH).build(), Rounding.builder((TimeValue)TimeValue.timeValueHours((long)12L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueHours((long)3L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueHours((long)1L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)30L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)10L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)5L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMinutes((long)1L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)30L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)10L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)5L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueSeconds((long)1L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)100L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)50L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)10L)).build(), Rounding.builder((TimeValue)TimeValue.timeValueMillis((long)1L)).build()};
    private final Expression field;
    private final Expression buckets;
    private final Expression from;
    private final Expression to;

    @FunctionInfo(returnType={"double", "date"})
    public AutoBucket(Source source, @Param(name="field", type={"integer", "long", "double", "date"}) Expression field, @Param(name="buckets", type={"integer"}) Expression buckets, @Param(name="from", type={"integer", "long", "double", "date"}) Expression from, @Param(name="to", type={"integer", "long", "double", "date"}) Expression to) {
        super(source, List.of(field, buckets, from, to));
        this.field = field;
        this.buckets = buckets;
        this.from = from;
        this.to = to;
    }

    public boolean foldable() {
        return this.field.foldable() && this.buckets.foldable() && this.from.foldable() && this.to.foldable();
    }

    @Override
    public Object fold() {
        return EvaluatorMapper.super.fold();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        int b = ((Number)this.buckets.fold()).intValue();
        if (this.field.dataType() == DataTypes.DATETIME) {
            long f = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.parseMillis(((BytesRef)this.from.fold()).utf8ToString());
            long t = DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.parseMillis(((BytesRef)this.to.fold()).utf8ToString());
            return DateTrunc.evaluator(this.source(), toEvaluator.apply(this.field), new DateRoundingPicker(b, f, t).pickRounding().prepareForUnknown());
        }
        if (this.field.dataType().isNumeric()) {
            double f = ((Number)this.from.fold()).doubleValue();
            double t = ((Number)this.to.fold()).doubleValue();
            Literal rounding = new Literal(this.source(), (Object)this.pickRounding(b, f, t), DataTypes.DOUBLE);
            Div div = new Div(this.source(), this.field, (Expression)rounding);
            Floor floor = new Floor(this.source(), (Expression)div);
            Mul mul = new Mul(this.source(), (Expression)floor, (Expression)rounding);
            return toEvaluator.apply((Expression)mul);
        }
        throw EsqlIllegalArgumentException.illegalDataType(this.field.dataType());
    }

    private double pickRounding(int buckets, double from, double to) {
        double precise = (to - from) / (double)buckets;
        double nextPowerOfTen = Math.pow(10.0, Math.ceil(Math.log10(precise)));
        double halfPower = nextPowerOfTen / 2.0;
        return precise < halfPower ? halfPower : nextPowerOfTen;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        if (this.field.dataType() == DataTypes.DATETIME) {
            return this.resolveType((e, o) -> TypeResolutions.isString((Expression)e, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)o));
        }
        if (this.field.dataType().isNumeric()) {
            return this.resolveType((e, o) -> TypeResolutions.isNumeric((Expression)e, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)o));
        }
        return TypeResolutions.isType((Expression)this.field, e -> false, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"datetime", "numeric"});
    }

    private Expression.TypeResolution resolveType(BiFunction<Expression, TypeResolutions.ParamOrdinal, Expression.TypeResolution> checkThirdAndForth) {
        Expression.TypeResolution resolution = TypeResolutions.isInteger((Expression)this.buckets, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isFoldable((Expression)this.buckets, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = checkThirdAndForth.apply(this.from, TypeResolutions.ParamOrdinal.THIRD);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = TypeResolutions.isFoldable((Expression)this.from, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.THIRD);
        if (resolution.unresolved()) {
            return resolution;
        }
        resolution = checkThirdAndForth.apply(this.to, TypeResolutions.ParamOrdinal.FOURTH);
        if (resolution.unresolved()) {
            return resolution;
        }
        return TypeResolutions.isFoldable((Expression)this.to, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FOURTH);
    }

    public DataType dataType() {
        if (this.field.dataType().isNumeric()) {
            return DataTypes.DOUBLE;
        }
        return this.field.dataType();
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new AutoBucket(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2), newChildren.get(3));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, AutoBucket::new, (Object)this.field, (Object)this.buckets, (Object)this.from, (Object)this.to);
    }

    public Expression field() {
        return this.field;
    }

    public Expression buckets() {
        return this.buckets;
    }

    public Expression from() {
        return this.from;
    }

    public Expression to() {
        return this.to;
    }

    public String toString() {
        return "AutoBucket{field=" + this.field + ", buckets=" + this.buckets + ", from=" + this.from + ", to=" + this.to + "}";
    }

    private record DateRoundingPicker(int buckets, long from, long to) {
        Rounding pickRounding() {
            Rounding prev = LARGEST_HUMAN_DATE_ROUNDING;
            for (Rounding r : HUMAN_DATE_ROUNDINGS) {
                if (!this.roundingIsOk(r)) {
                    return prev;
                }
                prev = r;
            }
            return prev;
        }

        boolean roundingIsOk(Rounding rounding) {
            Rounding.Prepared r = rounding.prepareForUnknown();
            long bucket = r.round(this.from);
            for (int used = 0; used < this.buckets; ++used) {
                bucket = r.nextRoundingValue(bucket);
                if (bucket <= this.to) continue;
                return true;
            }
            return false;
        }
    }
}

