/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.ip;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.network.CIDRUtils;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatchEvaluator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.util.CollectionUtils;

public class CIDRMatch
extends ScalarFunction
implements EvaluatorMapper {
    private final Expression ipField;
    private final List<Expression> matches;

    public CIDRMatch(Source source, Expression ipField, List<Expression> matches) {
        super(source, CollectionUtils.combine(Collections.singletonList(ipField), matches));
        this.ipField = ipField;
        this.matches = matches;
    }

    public Expression ipField() {
        return this.ipField;
    }

    public List<Expression> matches() {
        return this.matches;
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        EvalOperator.ExpressionEvaluator.Factory ipEvaluatorSupplier = toEvaluator.apply(this.ipField);
        return dvrCtx -> new CIDRMatchEvaluator(this.source(), ipEvaluatorSupplier.get(dvrCtx), (EvalOperator.ExpressionEvaluator[])this.matches.stream().map(x -> ((EvalOperator.ExpressionEvaluator.Factory)toEvaluator.apply((Expression)x)).get(dvrCtx)).toArray(EvalOperator.ExpressionEvaluator[]::new), dvrCtx);
    }

    static boolean process(BytesRef ip, BytesRef[] cidrs) {
        for (BytesRef cidr : cidrs) {
            if (!CIDRUtils.isInRange((byte[])Arrays.copyOfRange(ip.bytes, ip.offset, ip.offset + ip.length), (String)cidr.utf8ToString())) continue;
            return true;
        }
        return false;
    }

    public DataType dataType() {
        return DataTypes.BOOLEAN;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = TypeResolutions.isIPAndExact((Expression)this.ipField, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST);
        if (resolution.unresolved()) {
            return resolution;
        }
        int i = 1;
        for (Expression m : this.matches) {
            resolution = TypeResolutions.isStringAndExact((Expression)m, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)i++));
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return resolution;
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new CIDRMatch(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, CIDRMatch::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }
}

