/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import joptsimple.internal.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Warnings;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public abstract class AbstractConvertFunction
extends UnaryScalarFunction
implements EvaluatorMapper {
    private static final List<DataType> NUMERIC_TYPES = List.of(DataTypes.INTEGER, DataTypes.LONG, DataTypes.UNSIGNED_LONG, DataTypes.DOUBLE);
    public static final List<DataType> STRING_TYPES = DataTypes.types().stream().filter(EsqlDataTypes::isString).toList();

    protected AbstractConvertFunction(Source source, Expression field) {
        super(source, field);
    }

    protected EvalOperator.ExpressionEvaluator.Factory evaluator(EvalOperator.ExpressionEvaluator.Factory fieldEval) {
        DataType sourceType = this.field().dataType();
        BuildFactory factory = this.factories().get(sourceType);
        if (factory == null) {
            throw EsqlIllegalArgumentException.illegalDataType(sourceType);
        }
        return factory.build(fieldEval, this.source());
    }

    @Override
    protected final Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isType((Expression)this.field(), this.factories()::containsKey, (String)this.sourceText(), null, (String[])new String[]{AbstractConvertFunction.supportedTypesNames(this.factories().keySet())});
    }

    public static String supportedTypesNames(Set<DataType> types) {
        ArrayList<String> supportedTypesNames = new ArrayList<String>(types.size());
        HashSet<DataType> supportTypes = new HashSet<DataType>(types);
        if (supportTypes.containsAll(NUMERIC_TYPES)) {
            supportedTypesNames.add("numeric");
            NUMERIC_TYPES.forEach(supportTypes::remove);
        }
        if (types.containsAll(STRING_TYPES)) {
            supportedTypesNames.add("string");
            STRING_TYPES.forEach(supportTypes::remove);
        }
        supportTypes.forEach(t -> supportedTypesNames.add(t.name().toLowerCase(Locale.ROOT)));
        supportedTypesNames.sort(String::compareTo);
        return Strings.join(supportedTypesNames, (String)" or ");
    }

    protected abstract Map<DataType, BuildFactory> factories();

    @Override
    public final Object fold() {
        return EvaluatorMapper.super.fold();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        return this.evaluator(toEvaluator.apply(this.field()));
    }

    @FunctionalInterface
    static interface BuildFactory {
        public EvalOperator.ExpressionEvaluator.Factory build(EvalOperator.ExpressionEvaluator.Factory var1, Source var2);
    }

    public static abstract class AbstractEvaluator
    implements EvalOperator.ExpressionEvaluator {
        private static final Log logger = LogFactory.getLog(AbstractEvaluator.class);
        protected final DriverContext driverContext;
        private final EvalOperator.ExpressionEvaluator fieldEvaluator;
        private final Warnings warnings;

        protected AbstractEvaluator(DriverContext driverContext, EvalOperator.ExpressionEvaluator field, Source source) {
            this.driverContext = driverContext;
            this.fieldEvaluator = field;
            this.warnings = new Warnings(source);
        }

        protected abstract String name();

        protected abstract Block evalBlock(Block var1);

        protected abstract Block evalVector(Vector var1);

        public final Block eval(Page page) {
            try (Block block = this.fieldEvaluator.eval(page);){
                Vector vector = block.asVector();
                Block block2 = vector == null ? this.evalBlock(block) : this.evalVector(vector);
                return block2;
            }
        }

        protected final void registerException(Exception exception) {
            logger.trace((Object)"conversion failure", (Throwable)exception);
            this.warnings.registerException(exception);
        }

        public final String toString() {
            return this.name() + "Evaluator[field=" + this.fieldEvaluator + "]";
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable)this.fieldEvaluator);
        }
    }
}

