/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.conditional;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.scalar.ScalarFunction;
import org.elasticsearch.xpack.ql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public final class Case
extends ScalarFunction
implements EvaluatorMapper {
    private final List<Condition> conditions;
    private final Expression elseValue;
    private DataType dataType;

    public Case(Source source, Expression first, List<Expression> rest) {
        super(source, Stream.concat(Stream.of(first), rest.stream()).toList());
        int conditionCount = this.children().size() / 2;
        this.conditions = new ArrayList<Condition>(conditionCount);
        for (int c = 0; c < conditionCount; ++c) {
            this.conditions.add(new Condition((Expression)this.children().get(c * 2), (Expression)this.children().get(c * 2 + 1)));
        }
        this.elseValue = this.children().size() % 2 == 0 ? new Literal(source, null, DataTypes.NULL) : (Expression)this.children().get(this.children().size() - 1);
    }

    public DataType dataType() {
        if (this.dataType == null) {
            this.resolveType();
        }
        return this.dataType;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        if (this.children().size() < 2) {
            return new Expression.TypeResolution(LoggerMessageFormat.format(null, (String)"expected at least two arguments in [{}] but got {}", (Object[])new Object[]{this.sourceText(), this.children().size()}));
        }
        for (int c = 0; c < this.conditions.size(); ++c) {
            Condition condition = this.conditions.get(c);
            Expression.TypeResolution resolution = TypeResolutions.isBoolean((Expression)condition.condition, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)(c * 2)));
            if (resolution.unresolved()) {
                return resolution;
            }
            resolution = this.resolveValueType(condition.value, c * 2 + 1);
            if (!resolution.unresolved()) continue;
            return resolution;
        }
        return this.resolveValueType(this.elseValue, this.conditions.size() * 2);
    }

    private Expression.TypeResolution resolveValueType(Expression value, int position) {
        if (this.dataType == null || this.dataType == DataTypes.NULL) {
            this.dataType = value.dataType();
            return Expression.TypeResolution.TYPE_RESOLVED;
        }
        return TypeResolutions.isType((Expression)value, t -> t == this.dataType, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.fromIndex((int)position), (String[])new String[]{this.dataType.typeName()});
    }

    public Nullability nullable() {
        return Nullability.UNKNOWN;
    }

    public ScriptTemplate asScript() {
        throw new UnsupportedOperationException("functions do not support scripting");
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new Case(this.source(), newChildren.get(0), newChildren.subList(1, newChildren.size()));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, Case::new, (Object)((Expression)this.children().get(0)), this.children().subList(1, this.children().size()));
    }

    public boolean foldable() {
        for (Condition condition : this.conditions) {
            if (!condition.condition.foldable()) {
                return false;
            }
            Boolean b = (Boolean)condition.condition.fold();
            if (b == null || !b.booleanValue()) continue;
            return condition.value.foldable();
        }
        return this.elseValue.foldable();
    }

    @Override
    public Object fold() {
        for (Condition condition : this.conditions) {
            Boolean b = (Boolean)condition.condition.fold();
            if (b == null || !b.booleanValue()) continue;
            return condition.value.fold();
        }
        return this.elseValue.fold();
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(Function<Expression, EvalOperator.ExpressionEvaluator.Factory> toEvaluator) {
        final ElementType resultType = PlannerUtils.toElementType(this.dataType());
        final List<ConditionEvaluatorSupplier> conditionsFactories = this.conditions.stream().map(c -> new ConditionEvaluatorSupplier((EvalOperator.ExpressionEvaluator.Factory)toEvaluator.apply(c.condition), (EvalOperator.ExpressionEvaluator.Factory)toEvaluator.apply(c.value))).toList();
        final EvalOperator.ExpressionEvaluator.Factory elseValueFactory = toEvaluator.apply(this.elseValue);
        return new EvalOperator.ExpressionEvaluator.Factory(){

            public EvalOperator.ExpressionEvaluator get(DriverContext context) {
                return new CaseEvaluator(context, resultType, conditionsFactories.stream().map(x -> x.apply(context)).toList(), elseValueFactory.get(context));
            }

            public String toString() {
                return "CaseEvaluator[resultType=" + resultType + ", conditions=" + conditionsFactories + ", elseVal=" + elseValueFactory + "]";
            }
        };
    }

    record Condition(Expression condition, Expression value) {
    }

    record ConditionEvaluatorSupplier(EvalOperator.ExpressionEvaluator.Factory condition, EvalOperator.ExpressionEvaluator.Factory value) implements Function<DriverContext, ConditionEvaluator>
    {
        @Override
        public ConditionEvaluator apply(DriverContext driverContext) {
            return new ConditionEvaluator(this.condition.get(driverContext), this.value.get(driverContext));
        }

        @Override
        public String toString() {
            return "ConditionEvaluator[condition=" + this.condition + ", value=" + this.value + "]";
        }
    }

    private record CaseEvaluator(DriverContext driverContext, ElementType resultType, List<ConditionEvaluator> conditions, EvalOperator.ExpressionEvaluator elseVal) implements EvalOperator.ExpressionEvaluator
    {
        /*
         * Unable to fully structure code
         */
        public Block eval(Page page) {
            positionCount = page.getPositionCount();
            result = this.resultType.newBlockBuilder(positionCount, this.driverContext.blockFactory());
lbl3:
            // 3 sources

            try {
                for (p = 0; p < positionCount; ++p) {
                    positions = new int[]{p};
                    limited = new Page((Block[])IntStream.range(0, page.getBlockCount()).mapToObj((IntFunction<Block>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$eval$0(org.elasticsearch.compute.data.Page int[] int ), (I)Lorg/elasticsearch/compute/data/Block;)((Page)page, (int[])positions)).toArray((IntFunction<Block[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, lambda$eval$1(int ), (I)[Lorg/elasticsearch/compute/data/Block;)()));
                    ignored = (Releasable)LambdaMetafactory.metafactory(null, null, null, ()V, releaseBlocks(), ()V)((Page)limited);
                    for (ConditionEvaluator condition : this.conditions) {
                        b = (BooleanBlock)condition.condition.eval(limited);
                        try {
                            if (b.isNull(0) || !b.getBoolean(b.getFirstValueIndex(0))) continue;
                            values = condition.value.eval(limited);
                            try {
                                result.copyFrom(values, 0, 1);
                                if (values == null) ** GOTO lbl3
                            }
                            catch (Throwable var12_20) {
                                if (values != null) {
                                    try {
                                        values.close();
                                    }
                                    catch (Throwable var13_22) {
                                        var12_20.addSuppressed(var13_22);
                                    }
                                }
                                throw var12_20;
                            }
                            values.close();
                            ** GOTO lbl3
                        }
                        finally {
                            if (b == null) continue;
                            b.close();
                        }
                    }
                    values = this.elseVal.eval(limited);
                    try {
                        result.copyFrom(values, 0, 1);
                        continue;
                    }
                    finally {
                        if (ignored != null) {
                            ignored.close();
                        }
                    }
                }
                var4_5 = result.build();
                return var4_5;
            }
            finally {
                if (result != null) {
                    result.close();
                }
            }
        }

        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{() -> Releasables.close(this.conditions), this.elseVal});
        }

        @Override
        public String toString() {
            return "CaseEvaluator[resultType=" + this.resultType + ", conditions=" + this.conditions + ", elseVal=" + this.elseVal + "]";
        }

        private static /* synthetic */ Block[] lambda$eval$1(int x$0) {
            return new Block[x$0];
        }

        private static /* synthetic */ Block lambda$eval$0(Page page, int[] positions, int b) {
            return page.getBlock(b).filter(positions);
        }
    }

    record ConditionEvaluator(EvalOperator.ExpressionEvaluator condition, EvalOperator.ExpressionEvaluator value) implements Releasable
    {
        public void close() {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.condition, this.value});
        }
    }
}

