/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountDistinctBooleanAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountDistinctBytesRefAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountDistinctDoubleAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountDistinctIntAggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.CountDistinctLongAggregatorFunctionSupplier;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.expression.EsqlTypeResolutions;
import org.elasticsearch.xpack.esql.planner.ToAggregator;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.TypeResolutions;
import org.elasticsearch.xpack.ql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.ql.expression.function.aggregate.AggregateFunction;
import org.elasticsearch.xpack.ql.tree.Node;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;

public class CountDistinct
extends AggregateFunction
implements OptionalArgument,
ToAggregator {
    private static final int DEFAULT_PRECISION = 3000;
    private final Expression precision;

    public CountDistinct(Source source, Expression field, Expression precision) {
        super(source, field, precision != null ? List.of(precision) : List.of());
        this.precision = precision;
    }

    protected NodeInfo<CountDistinct> info() {
        return NodeInfo.create((Node)this, CountDistinct::new, (Object)this.field(), (Object)this.precision);
    }

    public CountDistinct replaceChildren(List<Expression> newChildren) {
        return new CountDistinct(this.source(), newChildren.get(0), newChildren.size() > 1 ? newChildren.get(1) : null);
    }

    public DataType dataType() {
        return DataTypes.LONG;
    }

    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        Expression.TypeResolution resolution = EsqlTypeResolutions.isExact(this.field(), this.sourceText(), TypeResolutions.ParamOrdinal.DEFAULT);
        if (resolution.unresolved() || this.precision == null) {
            return resolution;
        }
        return TypeResolutions.isInteger((Expression)this.precision, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND).and(TypeResolutions.isFoldable((Expression)this.precision, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.SECOND));
    }

    @Override
    public AggregatorFunctionSupplier supplier(BigArrays bigArrays, List<Integer> inputChannels) {
        int precision;
        DataType type = this.field().dataType();
        int n = precision = this.precision == null ? 3000 : ((Number)this.precision.fold()).intValue();
        if (type == DataTypes.BOOLEAN) {
            return new CountDistinctBooleanAggregatorFunctionSupplier(bigArrays, inputChannels);
        }
        if (type == DataTypes.DATETIME || type == DataTypes.LONG) {
            return new CountDistinctLongAggregatorFunctionSupplier(bigArrays, inputChannels, precision);
        }
        if (type == DataTypes.INTEGER) {
            return new CountDistinctIntAggregatorFunctionSupplier(bigArrays, inputChannels, precision);
        }
        if (type == DataTypes.DOUBLE) {
            return new CountDistinctDoubleAggregatorFunctionSupplier(bigArrays, inputChannels, precision);
        }
        if (type == DataTypes.KEYWORD || type == DataTypes.IP || type == DataTypes.TEXT) {
            return new CountDistinctBytesRefAggregatorFunctionSupplier(bigArrays, inputChannels, precision);
        }
        throw EsqlIllegalArgumentException.illegalDataType(type);
    }
}

