/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Avg;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Count;
import org.elasticsearch.xpack.esql.expression.function.aggregate.CountDistinct;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Max;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Median;
import org.elasticsearch.xpack.esql.expression.function.aggregate.MedianAbsoluteDeviation;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Min;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Percentile;
import org.elasticsearch.xpack.esql.expression.function.aggregate.Sum;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Case;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Greatest;
import org.elasticsearch.xpack.esql.expression.function.scalar.conditional.Least;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBoolean;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToCartesianPoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDatetime;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDegrees;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoPoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIP;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToInteger;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToRadians;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToString;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToVersion;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateExtract;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateFormat;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateParse;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.DateTrunc;
import org.elasticsearch.xpack.esql.expression.function.scalar.date.Now;
import org.elasticsearch.xpack.esql.expression.function.scalar.ip.CIDRMatch;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Abs;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Acos;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Asin;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Atan;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Atan2;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.AutoBucket;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Ceil;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cos;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cosh;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.E;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Floor;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.IsFinite;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.IsInfinite;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.IsNaN;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Log10;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Pi;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Pow;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Round;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Sin;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Sinh;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Sqrt;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Tan;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Tanh;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Tau;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvAvg;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvConcat;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvCount;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvDedupe;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMax;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMedian;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvMin;
import org.elasticsearch.xpack.esql.expression.function.scalar.multivalue.MvSum;
import org.elasticsearch.xpack.esql.expression.function.scalar.nulls.Coalesce;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Concat;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.EndsWith;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.LTrim;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Left;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Length;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.RTrim;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Replace;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Right;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Split;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.StartsWith;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Substring;
import org.elasticsearch.xpack.esql.expression.function.scalar.string.Trim;
import org.elasticsearch.xpack.esql.plan.logical.show.ShowFunctions;
import org.elasticsearch.xpack.ql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.ql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.ql.session.Configuration;

public final class EsqlFunctionRegistry
extends FunctionRegistry {
    public EsqlFunctionRegistry() {
        this.register(this.functions());
    }

    EsqlFunctionRegistry(FunctionDefinition ... functions) {
        this.register(functions);
    }

    private FunctionDefinition[][] functions() {
        return new FunctionDefinition[][]{{EsqlFunctionRegistry.def(Avg.class, Avg::new, (String[])new String[]{"avg"}), EsqlFunctionRegistry.def(Count.class, Count::new, (String[])new String[]{"count"}), EsqlFunctionRegistry.def(CountDistinct.class, CountDistinct::new, (String[])new String[]{"count_distinct"}), EsqlFunctionRegistry.def(Max.class, Max::new, (String[])new String[]{"max"}), EsqlFunctionRegistry.def(Median.class, Median::new, (String[])new String[]{"median"}), EsqlFunctionRegistry.def(MedianAbsoluteDeviation.class, MedianAbsoluteDeviation::new, (String[])new String[]{"median_absolute_deviation"}), EsqlFunctionRegistry.def(Min.class, Min::new, (String[])new String[]{"min"}), EsqlFunctionRegistry.def(Percentile.class, Percentile::new, (String[])new String[]{"percentile"}), EsqlFunctionRegistry.def(Sum.class, Sum::new, (String[])new String[]{"sum"})}, {EsqlFunctionRegistry.def(Abs.class, Abs::new, (String[])new String[]{"abs"}), EsqlFunctionRegistry.def(Acos.class, Acos::new, (String[])new String[]{"acos"}), EsqlFunctionRegistry.def(Asin.class, Asin::new, (String[])new String[]{"asin"}), EsqlFunctionRegistry.def(Atan.class, Atan::new, (String[])new String[]{"atan"}), EsqlFunctionRegistry.def(Atan2.class, Atan2::new, (String[])new String[]{"atan2"}), EsqlFunctionRegistry.def(AutoBucket.class, AutoBucket::new, (String[])new String[]{"auto_bucket"}), EsqlFunctionRegistry.def(Ceil.class, Ceil::new, (String[])new String[]{"ceil"}), EsqlFunctionRegistry.def(Cos.class, Cos::new, (String[])new String[]{"cos"}), EsqlFunctionRegistry.def(Cosh.class, Cosh::new, (String[])new String[]{"cosh"}), EsqlFunctionRegistry.def(E.class, E::new, (String[])new String[]{"e"}), EsqlFunctionRegistry.def(Floor.class, Floor::new, (String[])new String[]{"floor"}), EsqlFunctionRegistry.def(Greatest.class, Greatest::new, (String[])new String[]{"greatest"}), EsqlFunctionRegistry.def(IsFinite.class, IsFinite::new, (String[])new String[]{"is_finite"}), EsqlFunctionRegistry.def(IsInfinite.class, IsInfinite::new, (String[])new String[]{"is_infinite"}), EsqlFunctionRegistry.def(IsNaN.class, IsNaN::new, (String[])new String[]{"is_nan"}), EsqlFunctionRegistry.def(Log10.class, Log10::new, (String[])new String[]{"log10"}), EsqlFunctionRegistry.def(Least.class, Least::new, (String[])new String[]{"least"}), EsqlFunctionRegistry.def(Pi.class, Pi::new, (String[])new String[]{"pi"}), EsqlFunctionRegistry.def(Pow.class, Pow::new, (String[])new String[]{"pow"}), EsqlFunctionRegistry.def(Round.class, Round::new, (String[])new String[]{"round"}), EsqlFunctionRegistry.def(Sin.class, Sin::new, (String[])new String[]{"sin"}), EsqlFunctionRegistry.def(Sinh.class, Sinh::new, (String[])new String[]{"sinh"}), EsqlFunctionRegistry.def(Sqrt.class, Sqrt::new, (String[])new String[]{"sqrt"}), EsqlFunctionRegistry.def(Tan.class, Tan::new, (String[])new String[]{"tan"}), EsqlFunctionRegistry.def(Tanh.class, Tanh::new, (String[])new String[]{"tanh"}), EsqlFunctionRegistry.def(Tau.class, Tau::new, (String[])new String[]{"tau"})}, {EsqlFunctionRegistry.def(Length.class, Length::new, (String[])new String[]{"length"}), EsqlFunctionRegistry.def(Substring.class, Substring::new, (String[])new String[]{"substring"}), EsqlFunctionRegistry.def(Concat.class, Concat::new, (String[])new String[]{"concat"}), EsqlFunctionRegistry.def(LTrim.class, LTrim::new, (String[])new String[]{"ltrim"}), EsqlFunctionRegistry.def(RTrim.class, RTrim::new, (String[])new String[]{"rtrim"}), EsqlFunctionRegistry.def(Trim.class, Trim::new, (String[])new String[]{"trim"}), EsqlFunctionRegistry.def(Left.class, Left::new, (String[])new String[]{"left"}), EsqlFunctionRegistry.def(Replace.class, Replace::new, (String[])new String[]{"replace"}), EsqlFunctionRegistry.def(Right.class, Right::new, (String[])new String[]{"right"}), EsqlFunctionRegistry.def(StartsWith.class, StartsWith::new, (String[])new String[]{"starts_with"}), EsqlFunctionRegistry.def(EndsWith.class, EndsWith::new, (String[])new String[]{"ends_with"})}, {EsqlFunctionRegistry.def(DateExtract.class, DateExtract::new, (String[])new String[]{"date_extract"}), EsqlFunctionRegistry.def(DateFormat.class, DateFormat::new, (String[])new String[]{"date_format"}), EsqlFunctionRegistry.def(DateParse.class, DateParse::new, (String[])new String[]{"date_parse"}), EsqlFunctionRegistry.def(DateTrunc.class, DateTrunc::new, (String[])new String[]{"date_trunc"}), EsqlFunctionRegistry.def(Now.class, Now::new, (String[])new String[]{"now"})}, {EsqlFunctionRegistry.def(Case.class, Case::new, (String[])new String[]{"case"})}, {EsqlFunctionRegistry.def(Coalesce.class, Coalesce::new, (String[])new String[]{"coalesce"})}, {EsqlFunctionRegistry.def(CIDRMatch.class, CIDRMatch::new, (String[])new String[]{"cidr_match"})}, {EsqlFunctionRegistry.def(ToBoolean.class, ToBoolean::new, (String[])new String[]{"to_boolean", "to_bool"}), EsqlFunctionRegistry.def(ToCartesianPoint.class, ToCartesianPoint::new, (String[])new String[]{"to_cartesianpoint"}), EsqlFunctionRegistry.def(ToDatetime.class, ToDatetime::new, (String[])new String[]{"to_datetime", "to_dt"}), EsqlFunctionRegistry.def(ToDegrees.class, ToDegrees::new, (String[])new String[]{"to_degrees"}), EsqlFunctionRegistry.def(ToDouble.class, ToDouble::new, (String[])new String[]{"to_double", "to_dbl"}), EsqlFunctionRegistry.def(ToGeoPoint.class, ToGeoPoint::new, (String[])new String[]{"to_geopoint"}), EsqlFunctionRegistry.def(ToIP.class, ToIP::new, (String[])new String[]{"to_ip"}), EsqlFunctionRegistry.def(ToInteger.class, ToInteger::new, (String[])new String[]{"to_integer", "to_int"}), EsqlFunctionRegistry.def(ToLong.class, ToLong::new, (String[])new String[]{"to_long"}), EsqlFunctionRegistry.def(ToRadians.class, ToRadians::new, (String[])new String[]{"to_radians"}), EsqlFunctionRegistry.def(ToString.class, ToString::new, (String[])new String[]{"to_string", "to_str"}), EsqlFunctionRegistry.def(ToUnsignedLong.class, ToUnsignedLong::new, (String[])new String[]{"to_unsigned_long", "to_ulong", "to_ul"}), EsqlFunctionRegistry.def(ToVersion.class, ToVersion::new, (String[])new String[]{"to_version", "to_ver"})}, {EsqlFunctionRegistry.def(MvAvg.class, MvAvg::new, (String[])new String[]{"mv_avg"}), EsqlFunctionRegistry.def(MvConcat.class, MvConcat::new, (String[])new String[]{"mv_concat"}), EsqlFunctionRegistry.def(MvCount.class, MvCount::new, (String[])new String[]{"mv_count"}), EsqlFunctionRegistry.def(MvDedupe.class, MvDedupe::new, (String[])new String[]{"mv_dedupe"}), EsqlFunctionRegistry.def(MvMax.class, MvMax::new, (String[])new String[]{"mv_max"}), EsqlFunctionRegistry.def(MvMedian.class, MvMedian::new, (String[])new String[]{"mv_median"}), EsqlFunctionRegistry.def(MvMin.class, MvMin::new, (String[])new String[]{"mv_min"}), EsqlFunctionRegistry.def(MvSum.class, MvSum::new, (String[])new String[]{"mv_sum"}), EsqlFunctionRegistry.def(Split.class, Split::new, (String[])new String[]{"split"})}};
    }

    protected String normalize(String name) {
        return EsqlFunctionRegistry.normalizeName(name);
    }

    public static String normalizeName(String name) {
        return name.toLowerCase(Locale.ROOT);
    }

    public static FunctionDescription description(FunctionDefinition def) {
        String[] stringArray;
        String functionDescription;
        Constructor<?>[] constructors = def.clazz().getConstructors();
        if (constructors.length == 0) {
            return new FunctionDescription(def.name(), List.of(), null, null, false);
        }
        Constructor<?> constructor = constructors[0];
        FunctionInfo functionInfo = constructor.getAnnotation(FunctionInfo.class);
        String string = functionDescription = functionInfo == null ? "" : functionInfo.description();
        if (functionInfo == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "?";
        } else {
            stringArray = functionInfo.returnType();
        }
        String[] returnType = stringArray;
        Parameter[] params = constructor.getParameters();
        ArrayList<ArgSignature> args = new ArrayList<ArgSignature>(params.length);
        boolean variadic = false;
        for (int i = 1; i < params.length; ++i) {
            String[] stringArray3;
            if (Configuration.class.isAssignableFrom(params[i].getType())) continue;
            Param paramInfo = params[i].getAnnotation(Param.class);
            String name = paramInfo == null ? params[i].getName() : paramInfo.name();
            variadic |= List.class.isAssignableFrom(params[i].getType());
            if (paramInfo == null) {
                String[] stringArray4 = new String[1];
                stringArray3 = stringArray4;
                stringArray4[0] = "?";
            } else {
                stringArray3 = paramInfo.type();
            }
            String[] type = stringArray3;
            String desc = paramInfo == null ? "" : paramInfo.description();
            boolean optional = paramInfo == null ? false : paramInfo.optional();
            args.add(new ArgSignature(name, type, desc, optional));
        }
        return new FunctionDescription(def.name(), args, returnType, functionDescription, variadic);
    }

    public record FunctionDescription(String name, List<ArgSignature> args, String[] returnType, String description, boolean variadic) {
        public String fullSignature() {
            StringBuilder builder = new StringBuilder();
            builder.append(ShowFunctions.withPipes(this.returnType));
            builder.append(" ");
            builder.append(this.name);
            builder.append("(");
            for (int i = 0; i < this.args.size(); ++i) {
                ArgSignature arg = this.args.get(i);
                if (i > 0) {
                    builder.append(", ");
                }
                if (arg.optional()) {
                    builder.append("?");
                }
                builder.append(arg.name());
                if (i == this.args.size() - 1 && this.variadic) {
                    builder.append("...");
                }
                builder.append(":");
                builder.append(ShowFunctions.withPipes(arg.type()));
            }
            builder.append(")");
            return builder.toString();
        }

        public List<String> argNames() {
            return this.args.stream().map(ArgSignature::name).collect(Collectors.toList());
        }
    }

    public record ArgSignature(String name, String[] type, String description, boolean optional) {
    }
}

