/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.enrich.QueryList;

final class EnrichQuerySourceOperator
extends SourceOperator {
    private final BlockFactory blockFactory;
    private final QueryList queryList;
    private int queryPosition;
    private Weight weight = null;
    private final IndexReader indexReader;
    private int leafIndex = 0;
    private final IndexSearcher searcher;

    EnrichQuerySourceOperator(BlockFactory blockFactory, QueryList queryList, IndexReader indexReader) {
        this.blockFactory = blockFactory;
        this.queryList = queryList;
        this.indexReader = indexReader;
        this.searcher = new IndexSearcher(indexReader);
    }

    public void finish() {
    }

    public boolean isFinished() {
        return this.queryPosition >= this.queryList.getPositionCount();
    }

    public Page getOutput() {
        Query query;
        if (this.leafIndex == this.indexReader.leaves().size()) {
            ++this.queryPosition;
            this.leafIndex = 0;
            this.weight = null;
        }
        if (this.isFinished()) {
            return null;
        }
        if (this.weight == null && (query = this.queryList.getQuery(this.queryPosition)) != null) {
            try {
                query = this.searcher.rewrite((Query)new ConstantScoreQuery(query));
                this.weight = this.searcher.createWeight(query, ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        try {
            return this.queryOneLeaf(this.weight, this.leafIndex++);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    /*
     * Loose catch block
     */
    private Page queryOneLeaf(Weight weight, int leafIndex) throws IOException {
        Page page;
        IntVector.Builder docsBuilder;
        boolean success;
        IntVector positions;
        IntVector shards;
        IntVector segments;
        IntVector docs;
        block12: {
            block11: {
                if (weight == null) {
                    return null;
                }
                LeafReaderContext leafReaderContext = (LeafReaderContext)this.indexReader.leaves().get(leafIndex);
                BulkScorer scorer = weight.bulkScorer(leafReaderContext);
                if (scorer == null) {
                    return null;
                }
                docs = null;
                segments = null;
                shards = null;
                positions = null;
                success = false;
                docsBuilder = this.blockFactory.newIntVectorBuilder(1);
                scorer.score((LeafCollector)new DocCollector(docsBuilder), leafReaderContext.reader().getLiveDocs());
                docs = docsBuilder.build();
                int positionCount = docs.getPositionCount();
                segments = this.blockFactory.newConstantIntVector(leafIndex, positionCount);
                shards = this.blockFactory.newConstantIntVector(0, positionCount);
                positions = this.blockFactory.newConstantIntVector(this.queryPosition, positionCount);
                Page page2 = new Page(new Block[]{new DocVector(shards, segments, docs, Boolean.valueOf(true)).asBlock(), positions.asBlock()});
                success = true;
                page = page2;
                if (docsBuilder == null) break block11;
                docsBuilder.close();
            }
            if (success) break block12;
            Releasables.close((Releasable[])new Releasable[]{docs, shards, segments, positions});
        }
        return page;
        {
            catch (Throwable throwable) {
                try {
                    if (docsBuilder != null) {
                        try {
                            docsBuilder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable throwable3) {
                    if (!success) {
                        Releasables.close((Releasable[])new Releasable[]{docs, shards, segments, positions});
                    }
                    throw throwable3;
                }
            }
        }
    }

    public void close() {
    }

    private static class DocCollector
    implements LeafCollector {
        final IntVector.Builder docIds;

        DocCollector(IntVector.Builder docIds) {
            this.docIds = docIds;
        }

        public void setScorer(Scorable scorer) {
        }

        public void collect(int doc) {
            this.docIds.appendInt(doc);
        }
    }
}

