/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.enrich;

import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.compute.OwningChannelActionListener;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BlockStreamInput;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LocalCircuitBreaker;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.BlockReaderFactories;
import org.elasticsearch.compute.lucene.ValuesSourceReaderOperator;
import org.elasticsearch.compute.operator.Driver;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.OutputOperator;
import org.elasticsearch.compute.operator.ProjectOperator;
import org.elasticsearch.compute.operator.SinkOperator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.AbstractRefCounted;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.index.mapper.SourceLoader;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.enrich.EnrichQuerySourceOperator;
import org.elasticsearch.xpack.esql.enrich.MergePositionsOperator;
import org.elasticsearch.xpack.esql.enrich.QueryList;
import org.elasticsearch.xpack.esql.io.stream.PlanNameRegistry;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamOutput;
import org.elasticsearch.xpack.esql.planner.PlannerUtils;
import org.elasticsearch.xpack.esql.type.EsqlDataTypes;
import org.elasticsearch.xpack.ql.expression.Alias;
import org.elasticsearch.xpack.ql.expression.NamedExpression;

public class EnrichLookupService {
    public static final String LOOKUP_ACTION_NAME = "indices:data/read/esql/lookup";
    private final ClusterService clusterService;
    private final SearchService searchService;
    private final TransportService transportService;
    private final Executor executor;
    private final BigArrays bigArrays;
    private final BlockFactory blockFactory;
    private final LocalCircuitBreaker.SizeSettings localBreakerSettings;

    public EnrichLookupService(ClusterService clusterService, SearchService searchService, TransportService transportService, BigArrays bigArrays, BlockFactory blockFactory) {
        this.clusterService = clusterService;
        this.searchService = searchService;
        this.transportService = transportService;
        this.executor = transportService.getThreadPool().executor("esql");
        this.bigArrays = bigArrays;
        this.blockFactory = blockFactory;
        this.localBreakerSettings = new LocalCircuitBreaker.SizeSettings(clusterService.getSettings());
        transportService.registerRequestHandler(LOOKUP_ACTION_NAME, this.executor, in -> new LookupRequest(in, blockFactory), (TransportRequestHandler)new TransportHandler());
    }

    public void lookupAsync(String sessionId, CancellableTask parentTask, String index, String matchType, String matchField, List<NamedExpression> extractFields, Page inputPage, ActionListener<Page> outListener) {
        ThreadContext threadContext = this.transportService.getThreadPool().getThreadContext();
        ContextPreservingActionListener listener = ContextPreservingActionListener.wrapPreservingContext(outListener, (ThreadContext)threadContext);
        this.hasEnrichPrivilege((ActionListener<Void>)ActionListener.wrap(arg_0 -> this.lambda$lookupAsync$2(index, (ActionListener)listener, sessionId, matchType, matchField, inputPage, extractFields, threadContext, parentTask, arg_0), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
    }

    private void hasEnrichPrivilege(ActionListener<Void> outListener) {
        Settings settings = this.clusterService.getSettings();
        if (!settings.hasValue(XPackSettings.SECURITY_ENABLED.getKey()) || !((Boolean)XPackSettings.SECURITY_ENABLED.get(settings)).booleanValue()) {
            outListener.onResponse(null);
            return;
        }
        ThreadContext threadContext = this.transportService.getThreadPool().getThreadContext();
        SecurityContext securityContext = new SecurityContext(Settings.EMPTY, threadContext);
        User user = securityContext.getUser();
        if (user == null) {
            outListener.onFailure((Exception)new IllegalStateException("missing or unable to read authentication info on request"));
            return;
        }
        HasPrivilegesRequest request = new HasPrivilegesRequest();
        request.username(user.principal());
        request.clusterPrivileges(new String[]{ClusterPrivilegeResolver.MONITOR_ENRICH.name()});
        request.indexPrivileges(new RoleDescriptor.IndicesPrivileges[0]);
        request.applicationPrivileges(new RoleDescriptor.ApplicationResourcePrivileges[0]);
        ActionListener listener = outListener.delegateFailureAndWrap((l, resp) -> {
            if (resp.isCompleteMatch()) {
                l.onResponse(null);
                return;
            }
            String detailed = resp.getClusterPrivileges().entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(e -> "privilege [" + (String)e.getKey() + "] is missing").collect(Collectors.joining(", "));
            String message = "user [" + user.principal() + "] doesn't have sufficient privileges to perform enrich lookup: " + detailed;
            l.onFailure((Exception)Exceptions.authorizationError((String)message, (Object[])new Object[0]));
        });
        this.transportService.sendRequest(this.transportService.getLocalNode(), "cluster:admin/xpack/security/user/has_privileges", (TransportRequest)request, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(listener, HasPrivilegesResponse::new, this.executor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void doLookup(String sessionId, CancellableTask task, ShardId shardId, String matchType, String matchField, Page inputPage, List<NamedExpression> extractFields, ActionListener<Page> listener) {
        inputBlock = inputPage.getBlock(0);
        localBreaker = null;
        try {
            if (inputBlock.areAllValuesNull()) {
                listener.onResponse((Object)this.createNullResponse(inputPage.getPositionCount(), extractFields));
                return;
            }
            shardSearchRequest = new ShardSearchRequest(shardId, 0L, AliasFilter.EMPTY);
            searchContext = this.searchService.createSearchContext(shardSearchRequest, SearchService.NO_TIMEOUT);
            listener = ActionListener.runBefore(listener, (CheckedRunnable)(CheckedRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, close(), ()V)((SearchContext)searchContext));
            localBreaker = new LocalCircuitBreaker(this.blockFactory.breaker(), this.localBreakerSettings.overReservedBytes(), this.localBreakerSettings.maxOverReservedBytes());
            driverContext = new DriverContext(this.bigArrays, this.blockFactory.newChildFactory(localBreaker));
            searchExecutionContext = searchContext.getSearchExecutionContext();
            fieldType = searchExecutionContext.getFieldType(matchField);
            var17_17 = matchType;
            var18_18 = -1;
            switch (var17_17.hashCode()) {
                case 103668165: {
                    if (!var17_17.equals("match")) break;
                    var18_18 = 0;
                    break;
                }
                case 108280125: {
                    if (!var17_17.equals("range")) break;
                    var18_18 = 1;
                }
            }
            switch (var18_18) {
                case 0: 
                case 1: {
                    ** break;
                }
                default: {
                    throw new EsqlIllegalArgumentException("illegal match type " + matchType);
                }
lbl-1000:
                // 1 sources

                {
                    queryList = QueryList.termQueryList(fieldType, searchExecutionContext, inputBlock);
                    queryOperator = new EnrichQuerySourceOperator(driverContext.blockFactory(), queryList, searchExecutionContext.getIndexReader());
                }
            }
            intermediateOperators = new ArrayList<Object>(extractFields.size() + 2);
            mergingTypes = new ElementType[extractFields.size()];
            fields = new ArrayList<ValuesSourceReaderOperator.FieldInfo>(extractFields.size());
            for (i = 0; i < extractFields.size(); ++i) {
                extractField = extractFields.get(i);
                mergingTypes[i] = elementType = PlannerUtils.toElementType(extractField.dataType());
                v0 = List.of(searchContext);
                if (extractField instanceof Alias) {
                    a = (Alias)extractField;
                    v1 = ((NamedExpression)a.child()).name();
                } else {
                    v1 = extractField.name();
                }
                loaders = BlockReaderFactories.loaders(v0, (String)v1, (boolean)EsqlDataTypes.isUnsupported(extractField.dataType()));
                fields.add(new ValuesSourceReaderOperator.FieldInfo(extractField.name(), loaders));
            }
            intermediateOperators.add(new ValuesSourceReaderOperator(driverContext.blockFactory(), fields, List.of(new ValuesSourceReaderOperator.ShardContext(searchContext.searcher().getIndexReader(), (Supplier<SourceLoader>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doLookup$6(), ()Lorg/elasticsearch/index/mapper/SourceLoader;)())), 0));
            intermediateOperators.add(EnrichLookupService.droppingBlockOperator(extractFields.size() + 2, 0));
            singleLeaf = searchContext.searcher().getLeafContexts().size() == 1;
            mergingChannels = IntStream.range(0, extractFields.size()).map((IntUnaryOperator)LambdaMetafactory.metafactory(null, null, null, (I)I, lambda$doLookup$7(int ), (I)I)()).toArray();
            intermediateOperators.add(new MergePositionsOperator(singleLeaf, inputPage.getPositionCount(), 0, mergingChannels, mergingTypes, driverContext.blockFactory()));
            result = new AtomicReference<V>();
            outputOperator = new OutputOperator(List.of(), Function.identity(), (Consumer<Page>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, set(V ), (Lorg/elasticsearch/compute/data/Page;)V)(result));
            driver = new Driver("enrich-lookup:" + sessionId, driverContext, (Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$doLookup$8(java.lang.String org.elasticsearch.index.shard.ShardId java.lang.String java.lang.String java.util.List org.elasticsearch.compute.data.Page ), ()Ljava/lang/String;)((String)sessionId, (ShardId)shardId, (String)matchType, (String)matchField, extractFields, (Page)inputPage), (SourceOperator)queryOperator, intermediateOperators, (SinkOperator)outputOperator, Driver.DEFAULT_STATUS_INTERVAL, (Releasable)localBreaker);
            task.addListener((CancellableTask.CancellationListener)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$doLookup$9(org.elasticsearch.tasks.CancellableTask org.elasticsearch.compute.operator.Driver ), ()V)((CancellableTask)task, (Driver)driver));
            threadContext = this.transportService.getThreadPool().getThreadContext();
            localBreaker = null;
            Driver.start((ThreadContext)threadContext, (Executor)this.executor, (Driver)driver, (int)10000, (ActionListener)listener.map((CheckedFunction)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$doLookup$10(java.util.concurrent.atomic.AtomicReference org.elasticsearch.compute.data.Page java.util.List java.lang.Void ), (Ljava/lang/Void;)Lorg/elasticsearch/compute/data/Page;)((EnrichLookupService)this, result, (Page)inputPage, extractFields)));
            Releasables.close((Releasable)localBreaker);
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
        finally {
            Releasables.close(localBreaker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Page createNullResponse(int positionCount, List<NamedExpression> extractFields) {
        Block[] blocks = new Block[extractFields.size()];
        try {
            for (int i = 0; i < extractFields.size(); ++i) {
                blocks[i] = this.blockFactory.newConstantNullBlock(positionCount);
            }
            Page page = new Page(blocks);
            return page;
        }
        finally {
            if (blocks[blocks.length - 1] == null) {
                Releasables.close((Releasable[])blocks);
            }
        }
    }

    private static Operator droppingBlockOperator(int totalBlocks, int droppingPosition) {
        int size = totalBlocks - 1;
        ArrayList<Integer> projection = new ArrayList<Integer>(size);
        for (int i = 0; i < totalBlocks; ++i) {
            if (i == droppingPosition) continue;
            projection.add(i);
        }
        return new ProjectOperator(projection);
    }

    private static String lookupDescription(String sessionId, ShardId shardId, String matchType, String matchField, List<NamedExpression> extractFields, int positionCount) {
        return "ENRICH_LOOKUP( session=" + sessionId + " ,shard=" + shardId + " ,match_type=" + matchType + " ,match_field=" + matchField + " ,extract_fields=" + extractFields + " ,positions=" + positionCount + ")";
    }

    private /* synthetic */ Page lambda$doLookup$10(AtomicReference result, Page inputPage, List extractFields, Void ignored) throws Exception {
        Page out = (Page)result.get();
        if (out == null) {
            out = this.createNullResponse(inputPage.getPositionCount(), extractFields);
        }
        return out;
    }

    private static /* synthetic */ void lambda$doLookup$9(CancellableTask task, Driver driver) {
        String reason = Objects.requireNonNullElse(task.getReasonCancelled(), "task was cancelled");
        driver.cancel(reason);
    }

    private static /* synthetic */ String lambda$doLookup$8(String sessionId, ShardId shardId, String matchType, String matchField, List extractFields, Page inputPage) {
        return EnrichLookupService.lookupDescription(sessionId, shardId, matchType, matchField, extractFields, inputPage.getPositionCount());
    }

    private static /* synthetic */ int lambda$doLookup$7(int i) {
        return i + 1;
    }

    private static /* synthetic */ SourceLoader lambda$doLookup$6() {
        throw new UnsupportedOperationException("can't load _source as part of enrich");
    }

    private /* synthetic */ void lambda$lookupAsync$2(String index, ActionListener listener, String sessionId, String matchType, String matchField, Page inputPage, List extractFields, ThreadContext threadContext, CancellableTask parentTask, Void ignored) throws Exception {
        ClusterState clusterState = this.clusterService.state();
        GroupShardsIterator shardIterators = this.clusterService.operationRouting().searchShards(clusterState, new String[]{index}, Map.of(), "_local");
        if (shardIterators.size() != 1) {
            listener.onFailure((Exception)((Object)new EsqlIllegalArgumentException("target index {} has more than one shard", index)));
            return;
        }
        ShardIterator shardIt = (ShardIterator)shardIterators.get(0);
        ShardRouting shardRouting = shardIt.nextOrNull();
        if (shardRouting == null) {
            listener.onFailure((Exception)new UnavailableShardsException(shardIt.shardId(), "enrich index is not available", new Object[0]));
            return;
        }
        DiscoveryNode targetNode = clusterState.nodes().get(shardRouting.currentNodeId());
        LookupRequest lookupRequest = new LookupRequest(sessionId, shardIt.shardId(), matchType, matchField, inputPage, extractFields);
        try (ThreadContext.StoredContext unused = threadContext.stashWithOrigin("enrich");){
            this.transportService.sendChildRequest(targetNode, LOOKUP_ACTION_NAME, (TransportRequest)lookupRequest, (Task)parentTask, TransportRequestOptions.EMPTY, (TransportResponseHandler)new ActionListenerResponseHandler(listener.map(LookupResponse::takePage), in -> new LookupResponse(in, this.blockFactory), this.executor));
        }
    }

    private class TransportHandler
    implements TransportRequestHandler<LookupRequest> {
        private TransportHandler() {
        }

        public void messageReceived(LookupRequest request, TransportChannel channel, Task task) {
            request.incRef();
            ActionListener listener = ActionListener.runBefore((ActionListener)new OwningChannelActionListener(channel), request::decRef);
            EnrichLookupService.this.doLookup(request.sessionId, (CancellableTask)task, request.shardId, request.matchType, request.matchField, request.inputPage, request.extractFields, (ActionListener<Page>)listener.map(LookupResponse::new));
        }
    }

    private static class LookupRequest
    extends TransportRequest
    implements IndicesRequest {
        private final String sessionId;
        private final ShardId shardId;
        private final String matchType;
        private final String matchField;
        private final Page inputPage;
        private final List<NamedExpression> extractFields;
        private final Page toRelease;
        private final RefCounted refs = AbstractRefCounted.of(this::releasePage);

        LookupRequest(String sessionId, ShardId shardId, String matchType, String matchField, Page inputPage, List<NamedExpression> extractFields) {
            this.sessionId = sessionId;
            this.shardId = shardId;
            this.matchType = matchType;
            this.matchField = matchField;
            this.inputPage = inputPage;
            this.toRelease = null;
            this.extractFields = extractFields;
        }

        LookupRequest(StreamInput in, BlockFactory blockFactory) throws IOException {
            super(in);
            this.sessionId = in.readString();
            this.shardId = new ShardId(in);
            this.matchType = in.readString();
            this.matchField = in.readString();
            this.toRelease = this.inputPage = new Page((StreamInput)new BlockStreamInput(in, blockFactory));
            PlanStreamInput planIn = new PlanStreamInput(in, PlanNameRegistry.INSTANCE, in.namedWriteableRegistry(), null);
            this.extractFields = planIn.readCollectionAsList(PlanNameRegistry.PlanReader.readerFromPlanReader(PlanStreamInput::readNamedExpression));
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sessionId);
            out.writeWriteable((Writeable)this.shardId);
            out.writeString(this.matchType);
            out.writeString(this.matchField);
            out.writeWriteable((Writeable)this.inputPage);
            PlanStreamOutput planOut = new PlanStreamOutput(out, PlanNameRegistry.INSTANCE);
            planOut.writeCollection(this.extractFields, PlanNameRegistry.PlanWriter.writerFromPlanWriter(PlanStreamOutput::writeNamedExpression));
        }

        public String[] indices() {
            return new String[]{this.shardId.getIndexName()};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, "", parentTaskId, headers){

                public String getDescription() {
                    return EnrichLookupService.lookupDescription(sessionId, shardId, matchType, matchField, extractFields, inputPage.getPositionCount());
                }
            };
        }

        private void releasePage() {
            if (this.toRelease != null) {
                Releasables.closeExpectNoException(() -> ((Page)this.toRelease).releaseBlocks());
            }
        }

        public void incRef() {
            this.refs.incRef();
        }

        public boolean tryIncRef() {
            return this.refs.tryIncRef();
        }

        public boolean decRef() {
            return this.refs.decRef();
        }

        public boolean hasReferences() {
            return this.refs.hasReferences();
        }
    }

    private static class LookupResponse
    extends TransportResponse {
        private Page page;
        private final RefCounted refs = AbstractRefCounted.of(this::releasePage);

        LookupResponse(Page page) {
            this.page = page;
        }

        LookupResponse(StreamInput in, BlockFactory blockFactory) throws IOException {
            this.page = new Page((StreamInput)new BlockStreamInput(in, blockFactory));
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.page.writeTo(out);
        }

        Page takePage() {
            Page p = this.page;
            this.page = null;
            return p;
        }

        private void releasePage() {
            if (this.page != null) {
                Releasables.closeExpectNoException(() -> ((Page)this.page).releaseBlocks());
            }
        }

        public void incRef() {
            this.refs.incRef();
        }

        public boolean tryIncRef() {
            return this.refs.tryIncRef();
        }

        public boolean decRef() {
            return this.refs.decRef();
        }

        public boolean hasReferences() {
            return this.refs.hasReferences();
        }
    }
}

