/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.stack;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.features.FeatureService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;
import org.elasticsearch.xpack.core.template.IndexTemplateRegistry;
import org.elasticsearch.xpack.core.template.IngestPipelineConfig;
import org.elasticsearch.xpack.core.template.JsonIngestPipelineConfig;
import org.elasticsearch.xpack.core.template.LifecyclePolicyConfig;
import org.elasticsearch.xpack.stack.StackTemplateRegistry;

@Deprecated(since="8.12.0", forRemoval=true)
public class LegacyStackTemplateRegistry
extends IndexTemplateRegistry {
    private static final Logger logger = LogManager.getLogger(LegacyStackTemplateRegistry.class);
    public static final Version MIN_NODE_VERSION = Version.V_8_9_0;
    public static final int REGISTRY_VERSION = 4;
    public static final String TEMPLATE_VERSION_VARIABLE = "xpack.stack.template.version";
    private final ClusterService clusterService;
    private final FeatureService featureService;
    private volatile boolean stackTemplateEnabled;
    private static final Map<String, String> ADDITIONAL_TEMPLATE_VARIABLES = Map.of("xpack.stack.template.deprecated", "true");
    public static final String DATA_STREAMS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "data-streams-mappings";
    public static final String ECS_DYNAMIC_MAPPINGS_COMPONENT_TEMPLATE_NAME = "ecs@dynamic_templates";
    public static final String ILM_7_DAYS_POLICY_NAME = "7-days-default";
    public static final String ILM_30_DAYS_POLICY_NAME = "30-days-default";
    public static final String ILM_90_DAYS_POLICY_NAME = "90-days-default";
    public static final String ILM_180_DAYS_POLICY_NAME = "180-days-default";
    public static final String ILM_365_DAYS_POLICY_NAME = "365-days-default";
    public static final String LOGS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "logs-mappings";
    public static final String LOGS_SETTINGS_COMPONENT_TEMPLATE_NAME = "logs-settings";
    public static final String LOGS_ILM_POLICY_NAME = "logs";
    public static final String METRICS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "metrics-mappings";
    public static final String METRICS_SETTINGS_COMPONENT_TEMPLATE_NAME = "metrics-settings";
    public static final String METRICS_TSDB_SETTINGS_COMPONENT_TEMPLATE_NAME = "metrics-tsdb-settings";
    public static final String METRICS_ILM_POLICY_NAME = "metrics";
    public static final String SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE_NAME = "synthetics-mappings";
    public static final String SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE_NAME = "synthetics-settings";
    public static final String SYNTHETICS_ILM_POLICY_NAME = "synthetics";
    private static final List<LifecyclePolicyConfig> LIFECYCLE_POLICY_CONFIGS = List.of(new LifecyclePolicyConfig("logs", "/logs@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("metrics", "/metrics@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("synthetics", "/synthetics@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("7-days-default", "/7-days@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("30-days-default", "/30-days@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("90-days-default", "/90-days@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("180-days-default", "/180-days@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES), new LifecyclePolicyConfig("365-days-default", "/365-days@lifecycle.json", ADDITIONAL_TEMPLATE_VARIABLES));
    private static final Map<String, ComponentTemplate> COMPONENT_TEMPLATE_CONFIGS;
    private static final List<IngestPipelineConfig> INGEST_PIPELINE_CONFIGS;

    public LegacyStackTemplateRegistry(Settings nodeSettings, ClusterService clusterService, ThreadPool threadPool, Client client, NamedXContentRegistry xContentRegistry, FeatureService featureService) {
        super(nodeSettings, clusterService, threadPool, client, xContentRegistry);
        this.clusterService = clusterService;
        this.featureService = featureService;
        this.stackTemplateEnabled = (Boolean)StackTemplateRegistry.STACK_TEMPLATES_ENABLED.get(nodeSettings);
    }

    public void initialize() {
        super.initialize();
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(StackTemplateRegistry.STACK_TEMPLATES_ENABLED, this::updateEnabledSetting);
    }

    private void updateEnabledSetting(boolean newValue) {
        if (newValue) {
            this.stackTemplateEnabled = true;
        } else {
            logger.info("stack composable templates [{}] and component templates [{}] will not be installed or reinstalled", (Object)String.join((CharSequence)",", this.getComposableTemplateConfigs().keySet()), (Object)String.join((CharSequence)",", this.getComponentTemplateConfigs().keySet()));
            this.stackTemplateEnabled = false;
        }
    }

    protected List<LifecyclePolicyConfig> getLifecycleConfigs() {
        return LIFECYCLE_POLICY_CONFIGS;
    }

    protected List<LifecyclePolicy> getLifecyclePolicies() {
        if (this.stackTemplateEnabled) {
            return this.lifecyclePolicies;
        }
        return Collections.emptyList();
    }

    protected Map<String, ComponentTemplate> getComponentTemplateConfigs() {
        if (this.stackTemplateEnabled) {
            return COMPONENT_TEMPLATE_CONFIGS;
        }
        return Map.of();
    }

    protected Map<String, ComposableIndexTemplate> getComposableTemplateConfigs() {
        return Map.of();
    }

    protected List<IngestPipelineConfig> getIngestPipelines() {
        return INGEST_PIPELINE_CONFIGS;
    }

    protected String getOrigin() {
        return "stack";
    }

    protected boolean requiresMasterNode() {
        return true;
    }

    protected boolean isClusterReady(ClusterChangedEvent event) {
        return this.featureService.clusterHasFeature(event.state(), StackTemplateRegistry.STACK_TEMPLATES_FEATURE);
    }

    static {
        HashMap<String, ComponentTemplate> componentTemplates = new HashMap<String, ComponentTemplate>();
        for (IndexTemplateConfig config : List.of(new IndexTemplateConfig(DATA_STREAMS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/data-streams@mappings.json", 4, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(LOGS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/logs@mappings.json", 4, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(ECS_DYNAMIC_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/ecs@mappings.json", 4, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(LOGS_SETTINGS_COMPONENT_TEMPLATE_NAME, "/logs@settings.json", 4, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(METRICS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/metrics@mappings.json", 4, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(METRICS_SETTINGS_COMPONENT_TEMPLATE_NAME, "/metrics@settings.json", 4, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(METRICS_TSDB_SETTINGS_COMPONENT_TEMPLATE_NAME, "/metrics@tsdb-settings.json", 4, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(SYNTHETICS_MAPPINGS_COMPONENT_TEMPLATE_NAME, "/synthetics@mappings.json", 4, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES), new IndexTemplateConfig(SYNTHETICS_SETTINGS_COMPONENT_TEMPLATE_NAME, "/synthetics@settings.json", 4, TEMPLATE_VERSION_VARIABLE, ADDITIONAL_TEMPLATE_VARIABLES))) {
            try {
                componentTemplates.put(config.getTemplateName(), ComponentTemplate.parse((XContentParser)JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY, config.loadBytes())));
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }
        COMPONENT_TEMPLATE_CONFIGS = Map.copyOf(componentTemplates);
        INGEST_PIPELINE_CONFIGS = List.of(new JsonIngestPipelineConfig("logs@json-message", "/logs@json-pipeline.json", 4, TEMPLATE_VERSION_VARIABLE, List.of(), ADDITIONAL_TEMPLATE_VARIABLES), new JsonIngestPipelineConfig("logs-default-pipeline", "/logs@default-pipeline.json", 4, TEMPLATE_VERSION_VARIABLE, List.of(), ADDITIONAL_TEMPLATE_VARIABLES));
    }
}

