/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.asn1.ASN1Boolean;
import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.ExtendedRequest;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.ldap.sdk.unboundidds.extensions.ReplaceCertificateKeyStoreContent;
import com.unboundid.ldap.sdk.unboundidds.extensions.ReplaceCertificateTrustBehavior;
import com.unboundid.ldap.sdk.unboundidds.extensions.ReplaceListenerCertificateExtendedResult;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.util.ArrayList;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ReplaceListenerCertificateExtendedRequest
extends ExtendedRequest {
    @NotNull
    public static final String REPLACE_LISTENER_CERT_REQUEST_OID = "1.3.6.1.4.1.30221.2.6.68";
    private static final byte TYPE_KEY_MANAGER_PROVIDER = -125;
    private static final byte TYPE_TARGET_CERT_ALIAS = -122;
    private static final byte TYPE_RELOAD_HTTP_CONNECTION_HANDLER_CERTS = -121;
    private static final byte TYPE_SKIP_CERT_VALIDATION = -112;
    private static final long serialVersionUID = 3947876247774857671L;
    private final boolean reloadHTTPConnectionHandlerCertificates;
    private final boolean skipCertificateValidation;
    @NotNull
    private final ReplaceCertificateKeyStoreContent keyStoreContent;
    @NotNull
    private final ReplaceCertificateTrustBehavior trustBehavior;
    @NotNull
    private final String keyManagerProvider;
    @Nullable
    private final String targetCertificateAlias;

    public ReplaceListenerCertificateExtendedRequest(@NotNull ReplaceCertificateKeyStoreContent keyStoreContent, @NotNull String keyManagerProvider, @NotNull ReplaceCertificateTrustBehavior trustBehavior, @Nullable String targetCertificateAlias, boolean reloadHTTPConnectionHandlerCertificates, boolean skipCertificateValidation, Control ... requestControls) {
        super(REPLACE_LISTENER_CERT_REQUEST_OID, ReplaceListenerCertificateExtendedRequest.encodeValue(keyStoreContent, keyManagerProvider, trustBehavior, targetCertificateAlias, reloadHTTPConnectionHandlerCertificates, skipCertificateValidation), requestControls);
        this.keyStoreContent = keyStoreContent;
        this.keyManagerProvider = keyManagerProvider;
        this.trustBehavior = trustBehavior;
        this.targetCertificateAlias = targetCertificateAlias;
        this.reloadHTTPConnectionHandlerCertificates = reloadHTTPConnectionHandlerCertificates;
        this.skipCertificateValidation = skipCertificateValidation;
    }

    @NotNull
    private static ASN1OctetString encodeValue(@NotNull ReplaceCertificateKeyStoreContent keyStoreContent, @NotNull String keyManagerProvider, @NotNull ReplaceCertificateTrustBehavior trustBehavior, @Nullable String targetCertificateAlias, boolean reloadHTTPConnectionHandlerCertificates, boolean skipCertificateValidation) {
        Validator.ensureNotNullWithMessage(keyStoreContent, "ReplaceListenerCertificateExtendedRequest.keyStoreContent must not be null.");
        Validator.ensureNotNullOrEmpty(keyManagerProvider, "ReplaceListenerCertificateExtendedRequest.keyManagerProvider must not be null or empty.");
        Validator.ensureNotNullWithMessage(trustBehavior, "ReplaceListenerCertificateExtendedRequest.trustBehavior must not be null.");
        ArrayList<ASN1Element> valueElements = new ArrayList<ASN1Element>(6);
        valueElements.add(keyStoreContent.encode());
        valueElements.add(new ASN1OctetString(-125, keyManagerProvider));
        valueElements.add(trustBehavior.encode());
        if (targetCertificateAlias != null) {
            valueElements.add(new ASN1OctetString(-122, targetCertificateAlias));
        }
        if (reloadHTTPConnectionHandlerCertificates) {
            valueElements.add(new ASN1Boolean(-121, true));
        }
        if (skipCertificateValidation) {
            valueElements.add(new ASN1Boolean(-112, true));
        }
        return new ASN1OctetString(new ASN1Sequence(valueElements).encode());
    }

    public ReplaceListenerCertificateExtendedRequest(@NotNull ExtendedRequest request) throws LDAPException {
        super(request);
        ASN1OctetString value = request.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_REPLACE_LISTENER_CERT_REQ_NO_VALUE.get());
        }
        try {
            ASN1Element[] elements = ASN1Sequence.decodeAsSequence(value.getValue()).elements();
            this.keyStoreContent = ReplaceCertificateKeyStoreContent.decode(elements[0]);
            this.keyManagerProvider = ASN1OctetString.decodeAsOctetString(elements[1]).stringValue();
            this.trustBehavior = ReplaceCertificateTrustBehavior.decode(elements[2]);
            String targetAlias = null;
            boolean reloadHTTPCerts = false;
            boolean skipValidation = false;
            block7: for (int i = 3; i < elements.length; ++i) {
                switch (elements[i].getType()) {
                    case -122: {
                        targetAlias = elements[i].decodeAsOctetString().stringValue();
                        continue block7;
                    }
                    case -121: {
                        reloadHTTPCerts = elements[i].decodeAsBoolean().booleanValue();
                        continue block7;
                    }
                    case -112: {
                        skipValidation = elements[i].decodeAsBoolean().booleanValue();
                    }
                }
            }
            this.targetCertificateAlias = targetAlias;
            this.reloadHTTPConnectionHandlerCertificates = reloadHTTPCerts;
            this.skipCertificateValidation = skipValidation;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_REPLACE_LISTENER_CERT_DECODE_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    @NotNull
    public ReplaceCertificateKeyStoreContent getKeyStoreContent() {
        return this.keyStoreContent;
    }

    @NotNull
    public String getKeyManagerProvider() {
        return this.keyManagerProvider;
    }

    @NotNull
    public ReplaceCertificateTrustBehavior getTrustBehavior() {
        return this.trustBehavior;
    }

    @Nullable
    public String getTargetCertificateAlias() {
        return this.targetCertificateAlias;
    }

    public boolean reloadHTTPConnectionHandlerCertificates() {
        return this.reloadHTTPConnectionHandlerCertificates;
    }

    public boolean skipCertificateValidation() {
        return this.skipCertificateValidation;
    }

    @Override
    @NotNull
    public ReplaceListenerCertificateExtendedResult process(@NotNull LDAPConnection connection, int depth) throws LDAPException {
        ExtendedResult extendedResponse = super.process(connection, depth);
        return new ReplaceListenerCertificateExtendedResult(extendedResponse);
    }

    @Override
    @NotNull
    public String getExtendedRequestName() {
        return ExtOpMessages.INFO_REPLACE_LISTENER_CERT_REQUEST_NAME.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("ReplaceListenerCertificateExtendedRequest(oid='");
        buffer.append(this.getOID());
        buffer.append("', keyStoreContent=");
        this.keyStoreContent.toString(buffer);
        buffer.append(", keyManagerProvider='");
        buffer.append(this.keyManagerProvider);
        buffer.append("', trustBehavior=");
        this.trustBehavior.toString(buffer);
        if (this.targetCertificateAlias != null) {
            buffer.append(", targetCertificateAlias='");
            buffer.append(this.targetCertificateAlias);
            buffer.append('\'');
        }
        buffer.append(", reloadHTTPConnectionHandlerCertificates=");
        buffer.append(this.reloadHTTPConnectionHandlerCertificates);
        buffer.append(", skipCertificateValidation=");
        buffer.append(this.skipCertificateValidation);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }
}

