/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.unboundidds.controls.ControlMessages;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AdministrativeOperationRequestControl
extends Control {
    @NotNull
    public static final String ADMINISTRATIVE_OPERATION_REQUEST_OID = "1.3.6.1.4.1.30221.2.5.11";
    private static final long serialVersionUID = 4958642483402677725L;
    @Nullable
    private final String message;

    public AdministrativeOperationRequestControl() {
        this((String)null);
    }

    public AdministrativeOperationRequestControl(@Nullable String message) {
        super(ADMINISTRATIVE_OPERATION_REQUEST_OID, false, AdministrativeOperationRequestControl.encodeValue(message));
        this.message = message;
    }

    public AdministrativeOperationRequestControl(@NotNull Control control) {
        super(control);
        this.message = control.hasValue() ? control.getValue().stringValue() : null;
    }

    @Nullable
    private static ASN1OctetString encodeValue(@Nullable String message) {
        if (message == null) {
            return null;
        }
        return new ASN1OctetString(message);
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_ADMINISTRATIVE_OPERATION_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("AdministrativeOperationRequestControl(");
        if (this.message != null) {
            buffer.append("message='");
            buffer.append(this.message);
            buffer.append('\'');
        }
        buffer.append(')');
    }
}

