/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations.metrics;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.geo.BoundingBox;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.metrics.InternalBounds;
import org.elasticsearch.xpack.spatial.common.CartesianBoundingBox;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.search.aggregations.metrics.CartesianBounds;

public class InternalCartesianBounds
extends InternalBounds<CartesianPoint>
implements CartesianBounds {
    public final double left;
    public final double right;

    public InternalCartesianBounds(String name, double top, double bottom, double left, double right, Map<String, Object> metadata) {
        super(name, top, bottom, metadata);
        this.left = left;
        this.right = right;
    }

    public InternalCartesianBounds(StreamInput in) throws IOException {
        super(in);
        this.left = in.readDouble();
        this.right = in.readDouble();
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        out.writeDouble(this.left);
        out.writeDouble(this.right);
    }

    static InternalCartesianBounds empty(String name, Map<String, Object> metadata) {
        return new InternalCartesianBounds(name, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, metadata);
    }

    public String getWriteableName() {
        return "cartesian_bounds";
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        double top = Double.NEGATIVE_INFINITY;
        double bottom = Double.POSITIVE_INFINITY;
        double left = Double.POSITIVE_INFINITY;
        double right = Double.NEGATIVE_INFINITY;
        for (InternalAggregation aggregation : aggregations) {
            InternalCartesianBounds bounds = (InternalCartesianBounds)aggregation;
            top = Math.max(top, bounds.top);
            bottom = Math.min(bottom, bounds.bottom);
            left = Math.min(left, bounds.left);
            right = Math.max(right, bounds.right);
        }
        return new InternalCartesianBounds(this.name, top, bottom, left, right, this.getMetadata());
    }

    protected Object selectCoordinate(String coordinateString, CartesianPoint cornerPoint) {
        return switch (coordinateString) {
            case "x" -> cornerPoint.getX();
            case "y" -> cornerPoint.getY();
            default -> throw new IllegalArgumentException("Found unknown path element [" + coordinateString + "] in [" + this.getName() + "]");
        };
    }

    protected BoundingBox<CartesianPoint> resolveBoundingBox() {
        if (Double.isInfinite(this.top)) {
            return null;
        }
        return new CartesianBoundingBox(new CartesianPoint(this.left, this.top), new CartesianPoint(this.right, this.bottom));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalCartesianBounds other = (InternalCartesianBounds)obj;
        return this.top == other.top && this.bottom == other.bottom && this.left == other.left && this.right == other.right;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.bottom, this.left, this.right);
    }
}

