/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.geo.GeoEncodingUtils;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.AggregationReduceContext;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.spatial.search.aggregations.GeoShapeMetricAggregation;
import org.elasticsearch.xpack.spatial.search.aggregations.MergedGeoLines;

public class InternalGeoLine
extends InternalAggregation
implements GeoShapeMetricAggregation {
    private static final double SCALE = Math.pow(10.0, 6.0);
    private final long[] line;
    private final double[] sortVals;
    private final boolean complete;
    private final boolean includeSorts;
    private final SortOrder sortOrder;
    private final int size;
    private final boolean nonOverlapping;
    private final boolean simplified;

    InternalGeoLine(String name, long[] line, double[] sortVals, Map<String, Object> metadata, boolean complete, boolean includeSorts, SortOrder sortOrder, int size, boolean nonOverlapping, boolean simplified) {
        super(name, metadata);
        this.line = line;
        this.sortVals = sortVals;
        this.complete = complete;
        this.includeSorts = includeSorts;
        this.sortOrder = sortOrder;
        this.size = size;
        this.nonOverlapping = nonOverlapping;
        this.simplified = simplified;
    }

    public InternalGeoLine(StreamInput in) throws IOException {
        super(in);
        this.line = in.readLongArray();
        this.sortVals = in.readDoubleArray();
        this.complete = in.readBoolean();
        this.includeSorts = in.readBoolean();
        this.sortOrder = SortOrder.readFromStream((StreamInput)in);
        this.size = in.readVInt();
        if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_500_020)) {
            this.nonOverlapping = in.readBoolean();
            this.simplified = in.readBoolean();
        } else {
            this.nonOverlapping = false;
            this.simplified = false;
        }
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeLongArray(this.line);
        out.writeDoubleArray(this.sortVals);
        out.writeBoolean(this.complete);
        out.writeBoolean(this.includeSorts);
        this.sortOrder.writeTo(out);
        out.writeVInt(this.size);
        if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_500_020)) {
            out.writeBoolean(this.nonOverlapping);
            out.writeBoolean(this.simplified);
        }
    }

    public InternalAggregation reduce(List<InternalAggregation> aggregations, AggregationReduceContext reduceContext) {
        int mergedSize = 0;
        boolean reducedComplete = true;
        boolean reducedIncludeSorts = true;
        boolean reducedNonOverlapping = this.nonOverlapping;
        boolean reducedSimplified = this.simplified;
        ArrayList<InternalGeoLine> internalGeoLines = new ArrayList<InternalGeoLine>(aggregations.size());
        for (InternalAggregation aggregation : aggregations) {
            InternalGeoLine geoLine = (InternalGeoLine)aggregation;
            internalGeoLines.add(geoLine);
            mergedSize += geoLine.line.length;
            reducedComplete &= geoLine.complete;
            reducedIncludeSorts &= geoLine.includeSorts;
            reducedNonOverlapping &= geoLine.nonOverlapping;
            reducedSimplified |= geoLine.simplified;
        }
        boolean bl = mergedSize <= this.size;
        int finalSize = Math.min(mergedSize, this.size);
        MergedGeoLines mergedGeoLines = reducedNonOverlapping ? new MergedGeoLines.NonOverlapping(internalGeoLines, finalSize, this.sortOrder, reducedSimplified) : new MergedGeoLines.Overlapping(internalGeoLines, finalSize, this.sortOrder, reducedSimplified);
        mergedGeoLines.merge();
        return new InternalGeoLine(this.name, mergedGeoLines.getFinalPoints(), mergedGeoLines.getFinalSortValues(), this.getMetadata(), reducedComplete &= bl, reducedIncludeSorts, this.sortOrder, this.size, this.nonOverlapping, this.simplified);
    }

    protected boolean mustReduceOnSingleInternalAgg() {
        return true;
    }

    public String getWriteableName() {
        return "geo_line";
    }

    public long[] line() {
        return this.line;
    }

    public double[] sortVals() {
        return this.sortVals;
    }

    public int length() {
        return this.line == null ? 0 : this.line.length;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean includeSorts() {
        return this.includeSorts;
    }

    public SortOrder sortOrder() {
        return this.sortOrder;
    }

    public int size() {
        return this.size;
    }

    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("type", "Feature").field("geometry", this.geoJSONGeometry()).startObject("properties").field("complete", this.isComplete());
        if (this.includeSorts) {
            builder.field("sort_values", (Object)this.sortVals);
        }
        builder.endObject();
        return builder;
    }

    private double roundDegrees(double degree) {
        return (double)Math.round(degree * SCALE) / SCALE;
    }

    public Object getProperty(List<String> path) {
        if (path.isEmpty()) {
            return this;
        }
        if (path.size() == 1 && "value".equals(path.get(0))) {
            return this.line;
        }
        throw new IllegalArgumentException("path not supported for [" + this.getName() + "]: " + path);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.line), Arrays.hashCode(this.sortVals), this.complete, this.includeSorts, this.sortOrder, this.size);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        InternalGeoLine that = (InternalGeoLine)((Object)obj);
        return super.equals(obj) && Arrays.equals(this.line, that.line) && Arrays.equals(this.sortVals, that.sortVals) && Objects.equals(this.complete, that.complete) && Objects.equals(this.includeSorts, that.includeSorts) && Objects.equals(this.sortOrder, that.sortOrder) && Objects.equals(this.size, that.size);
    }

    public Map<String, Object> geoJSONGeometry() {
        ArrayList<double[]> coordinates = new ArrayList<double[]>();
        for (int i = 0; i < this.line.length; ++i) {
            int x = (int)(this.line[i] >> 32);
            int y = (int)this.line[i];
            coordinates.add(new double[]{this.roundDegrees(GeoEncodingUtils.decodeLongitude((int)x)), this.roundDegrees(GeoEncodingUtils.decodeLatitude((int)y))});
        }
        HashMap<String, Object> geoJSON = new HashMap<String, Object>();
        if (coordinates.size() == 1) {
            geoJSON.put("type", "Point");
            geoJSON.put("coordinates", coordinates.get(0));
        } else {
            geoJSON.put("type", "LineString");
            geoJSON.put("coordinates", coordinates.toArray());
        }
        return geoJSON;
    }
}

