/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.geo.Component2D;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.elasticsearch.xpack.spatial.index.fielddata.Component2DVisitor;
import org.elasticsearch.xpack.spatial.index.fielddata.CoordinateEncoder;
import org.elasticsearch.xpack.spatial.index.fielddata.GeometryDocValueReader;

abstract class ShapeDocValuesQuery<GEOMETRY>
extends Query {
    private final String field;
    private final CoordinateEncoder encoder;
    private final ShapeField.QueryRelation relation;
    private final GEOMETRY[] geometries;

    ShapeDocValuesQuery(String field, CoordinateEncoder encoder, ShapeField.QueryRelation relation, GEOMETRY[] geometries) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field;
        this.encoder = encoder;
        this.relation = relation;
        this.geometries = geometries;
    }

    protected abstract Component2D create(GEOMETRY var1);

    protected abstract Component2D create(GEOMETRY[] var1);

    protected void add(List<Component2D> components2D, GEOMETRY geometry) {
        components2D.add(this.create(geometry));
    }

    public String toString(String otherField) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(otherField)) {
            sb.append(this.field);
            sb.append(':');
            sb.append(this.relation);
            sb.append(':');
        }
        sb.append(Arrays.toString(this.geometries));
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        ShapeDocValuesQuery other = (ShapeDocValuesQuery)((Object)obj);
        return this.field.equals(other.field) && this.relation == other.relation && Arrays.equals(this.geometries, other.geometries);
    }

    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + this.relation.hashCode();
        h = 31 * h + Arrays.hashCode(this.geometries);
        return h;
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
        }
    }

    public Weight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) {
        if (this.relation == ShapeField.QueryRelation.CONTAINS) {
            return this.getContainsWeight(scoreMode, boost);
        }
        return this.getStandardWeight(scoreMode, boost);
    }

    private ConstantScoreWeight getStandardWeight(final ScoreMode scoreMode, float boost) {
        final Component2D component2D = this.create(this.geometries);
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            public ScorerSupplier scorerSupplier(final LeafReaderContext context) {
                1 weight = this;
                return new ScorerSupplier((Weight)weight){
                    final /* synthetic */ Weight val$weight;
                    {
                        this.val$weight = weight;
                    }

                    public Scorer get(long leadCost) throws IOException {
                        final BinaryDocValues values = context.reader().getBinaryDocValues(ShapeDocValuesQuery.this.field);
                        if (values == null) {
                            return null;
                        }
                        final GeometryDocValueReader reader = new GeometryDocValueReader();
                        final Component2DVisitor visitor = Component2DVisitor.getVisitor(component2D, ShapeDocValuesQuery.this.relation, ShapeDocValuesQuery.this.encoder);
                        TwoPhaseIterator iterator = new TwoPhaseIterator((DocIdSetIterator)values){

                            public boolean matches() throws IOException {
                                reader.reset(values.binaryValue());
                                visitor.reset();
                                reader.visit(visitor);
                                return visitor.matches();
                            }

                            public float matchCost() {
                                return 1000.0f;
                            }
                        };
                        return new ConstantScoreScorer(this.val$weight, this.score(), scoreMode, iterator);
                    }

                    public long cost() {
                        return context.reader().maxDoc();
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{ShapeDocValuesQuery.this.field});
            }
        };
    }

    private ConstantScoreWeight getContainsWeight(final ScoreMode scoreMode, float boost) {
        final ArrayList<Component2D> components2D = new ArrayList<Component2D>(this.geometries.length);
        for (GEOMETRY geometry : this.geometries) {
            this.add(components2D, geometry);
        }
        return new ConstantScoreWeight(this, boost){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            public ScorerSupplier scorerSupplier(final LeafReaderContext context) {
                2 weight = this;
                return new ScorerSupplier((Weight)weight){
                    final /* synthetic */ Weight val$weight;
                    {
                        this.val$weight = weight;
                    }

                    public Scorer get(long leadCost) throws IOException {
                        final BinaryDocValues values = context.reader().getBinaryDocValues(ShapeDocValuesQuery.this.field);
                        if (values == null) {
                            return null;
                        }
                        final Component2DVisitor[] visitors = new Component2DVisitor[components2D.size()];
                        for (int i = 0; i < components2D.size(); ++i) {
                            visitors[i] = Component2DVisitor.getVisitor((Component2D)components2D.get(i), ShapeDocValuesQuery.this.relation, ShapeDocValuesQuery.this.encoder);
                        }
                        final GeometryDocValueReader reader = new GeometryDocValueReader();
                        TwoPhaseIterator iterator = new TwoPhaseIterator((DocIdSetIterator)values){

                            public boolean matches() throws IOException {
                                reader.reset(values.binaryValue());
                                for (Component2DVisitor visitor : visitors) {
                                    visitor.reset();
                                    reader.visit(visitor);
                                    if (visitor.matches()) continue;
                                    return false;
                                }
                                return true;
                            }

                            public float matchCost() {
                                return 1000.0f;
                            }
                        };
                        return new ConstantScoreScorer(this.val$weight, this.score(), scoreMode, iterator);
                    }

                    public long cost() {
                        return context.reader().maxDoc();
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return DocValues.isCacheable((LeafReaderContext)ctx, (String[])new String[]{ShapeDocValuesQuery.this.field});
            }
        };
    }
}

