/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.common;

import java.io.IOException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.geo.BoundingBox;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.SpatialPoint;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;

public class CartesianBoundingBox
extends BoundingBox<CartesianPoint> {
    public static final ParseField X_FIELD = new ParseField("x", new String[0]);
    public static final ParseField Y_FIELD = new ParseField("y", new String[0]);

    public CartesianBoundingBox(CartesianPoint topLeft, CartesianPoint bottomRight) {
        super((SpatialPoint)topLeft, (SpatialPoint)bottomRight);
    }

    public CartesianBoundingBox(StreamInput input) throws IOException {
        super((SpatialPoint)new CartesianPoint(input.readDouble(), input.readDouble()), (SpatialPoint)new CartesianPoint(input.readDouble(), input.readDouble()));
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder) throws IOException {
        builder.startObject(TOP_LEFT_FIELD.getPreferredName());
        builder.field(X_FIELD.getPreferredName(), ((CartesianPoint)this.topLeft).getX());
        builder.field(Y_FIELD.getPreferredName(), ((CartesianPoint)this.topLeft).getY());
        builder.endObject();
        builder.startObject(BOTTOM_RIGHT_FIELD.getPreferredName());
        builder.field(X_FIELD.getPreferredName(), ((CartesianPoint)this.bottomRight).getX());
        builder.field(Y_FIELD.getPreferredName(), ((CartesianPoint)this.bottomRight).getY());
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeDouble(((CartesianPoint)this.topLeft).getX());
        out.writeDouble(((CartesianPoint)this.topLeft).getY());
        out.writeDouble(((CartesianPoint)this.bottomRight).getX());
        out.writeDouble(((CartesianPoint)this.bottomRight).getY());
    }

    public final String getWriteableName() {
        return "CartesianBoundingBox";
    }

    public final TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.GENERIC_NAMED_WRITABLE_ADDED;
    }

    public static CartesianBoundingBox parseBoundingBox(XContentParser parser) throws IOException, ElasticsearchParseException {
        CartesianBoundsParser bounds = new CartesianBoundsParser(parser);
        return (CartesianBoundingBox)bounds.parseBoundingBox();
    }

    protected static class CartesianBoundsParser
    extends BoundingBox.BoundsParser<CartesianBoundingBox> {
        CartesianBoundsParser(XContentParser parser) {
            super(parser);
        }

        protected CartesianBoundingBox createWithEnvelope() {
            CartesianPoint topLeft = new CartesianPoint(this.envelope.getMinLon(), this.envelope.getMaxLat());
            CartesianPoint bottomRight = new CartesianPoint(this.envelope.getMaxLon(), this.envelope.getMinLat());
            return new CartesianBoundingBox(topLeft, bottomRight);
        }

        protected CartesianBoundingBox createWithBounds() {
            CartesianPoint topLeft = new CartesianPoint(this.left, this.top);
            CartesianPoint bottomRight = new CartesianPoint(this.right, this.bottom);
            return new CartesianBoundingBox(topLeft, bottomRight);
        }

        protected SpatialPoint parsePointWith(XContentParser parser, GeoUtils.EffectivePoint effectivePoint) throws IOException {
            return CartesianPoint.parsePoint(parser, false);
        }
    }
}

