/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.api;

import java.net.InetAddress;
import java.util.Arrays;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.core.Tuple;

public class CIDR {
    private final byte[] lower;
    private final byte[] upper;

    public CIDR(String cidr) {
        if (cidr.contains("/")) {
            Tuple<byte[], byte[]> range = CIDR.getLowerUpper((Tuple<InetAddress, Integer>)InetAddresses.parseCidr((String)cidr));
            this.lower = (byte[])range.v1();
            this.upper = (byte[])range.v2();
        } else {
            this.lower = InetAddresses.forString((String)cidr).getAddress();
            this.upper = this.lower;
        }
    }

    public boolean contains(String addressToCheck) {
        if (addressToCheck == null || "".equals(addressToCheck)) {
            return false;
        }
        byte[] parsedAddress = InetAddresses.forString((String)addressToCheck).getAddress();
        return CIDR.isBetween(parsedAddress, this.lower, this.upper);
    }

    private static Tuple<byte[], byte[]> getLowerUpper(Tuple<InetAddress, Integer> cidr) {
        InetAddress value = (InetAddress)cidr.v1();
        Integer prefixLength = (Integer)cidr.v2();
        if (prefixLength < 0 || prefixLength > 8 * value.getAddress().length) {
            throw new IllegalArgumentException("illegal prefixLength '" + prefixLength + "'. Must be 0-32 for IPv4 ranges, 0-128 for IPv6 ranges");
        }
        byte[] lower = value.getAddress();
        byte[] upper = value.getAddress();
        for (int i = prefixLength.intValue(); i < 8 * lower.length; ++i) {
            int m = 1 << 7 - (i & 7);
            int n = i >> 3;
            lower[n] = (byte)(lower[n] & (byte)(~m));
            int n2 = i >> 3;
            upper[n2] = (byte)(upper[n2] | (byte)m);
        }
        return new Tuple((Object)lower, (Object)upper);
    }

    private static boolean isBetween(byte[] addr, byte[] lower, byte[] upper) {
        if (addr.length != lower.length) {
            addr = CIDR.encode(addr);
            lower = CIDR.encode(lower);
            upper = CIDR.encode(upper);
        }
        return Arrays.compareUnsigned(lower, addr) <= 0 && Arrays.compareUnsigned(upper, addr) >= 0;
    }

    private static byte[] encode(byte[] address) {
        byte[] IPV4_PREFIX = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1};
        if (address.length == 4) {
            byte[] mapped = new byte[16];
            System.arraycopy(IPV4_PREFIX, 0, mapped, 0, IPV4_PREFIX.length);
            System.arraycopy(address, 0, mapped, IPV4_PREFIX.length, address.length);
            address = mapped;
        } else if (address.length != 16) {
            throw new UnsupportedOperationException("Only IPv4 and IPv6 addresses are supported");
        }
        return address;
    }
}

