/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.operator;

import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.elasticsearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.xpack.security.operator.OperatorOnlyRegistry;
import org.elasticsearch.xpack.security.operator.OperatorPrivilegesViolation;

public class DefaultOperatorOnlyRegistry
implements OperatorOnlyRegistry {
    public static final Set<String> SIMPLE_ACTIONS = Set.of("cluster:admin/voting_config/add_exclusions", "cluster:admin/voting_config/clear_exclusions", "cluster:admin/xpack/license/put", "cluster:admin/xpack/license/delete", "cluster:admin/autoscaling/put_autoscaling_policy", "cluster:admin/autoscaling/delete_autoscaling_policy", "cluster:admin/repository/analyze", "cluster:admin/shutdown/create", "cluster:admin/shutdown/get", "cluster:admin/shutdown/delete", "cluster:admin/shutdown/prevalidate_removal", "cluster:admin/desired_nodes/delete", "cluster:admin/desired_nodes/get", "cluster:admin/desired_nodes/update", "cluster:admin/desired_balance/get", "cluster:admin/desired_balance/reset");
    private final ClusterSettings clusterSettings;

    public DefaultOperatorOnlyRegistry(ClusterSettings clusterSettings) {
        this.clusterSettings = clusterSettings;
    }

    @Override
    public OperatorPrivilegesViolation check(String action, TransportRequest request) {
        if (SIMPLE_ACTIONS.contains(action)) {
            return () -> "action [" + action + "]";
        }
        if ("cluster:admin/settings/update".equals(action)) {
            assert (request instanceof ClusterUpdateSettingsRequest);
            return this.checkClusterUpdateSettings((ClusterUpdateSettingsRequest)request);
        }
        return null;
    }

    @Override
    public OperatorPrivilegesViolation checkRest(RestHandler restHandler, RestRequest restRequest, RestChannel restChannel) {
        return null;
    }

    private OperatorPrivilegesViolation checkClusterUpdateSettings(ClusterUpdateSettingsRequest request) {
        List<String> operatorOnlySettingKeys = Stream.concat(request.transientSettings().keySet().stream(), request.persistentSettings().keySet().stream()).filter(k -> {
            Setting setting = this.clusterSettings.get(k);
            return setting != null && setting.isOperatorOnly();
        }).toList();
        if (!operatorOnlySettingKeys.isEmpty()) {
            return () -> (operatorOnlySettingKeys.size() == 1 ? "setting" : "settings") + " [" + Strings.collectionToDelimitedString((Iterable)operatorOnlySettingKeys, (String)",") + "]";
        }
        return null;
    }
}

