/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.store;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Strings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.common.IteratingActionListener;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.store.ReservedRolesStore;
import org.elasticsearch.xpack.core.security.authz.store.RoleReference;
import org.elasticsearch.xpack.core.security.authz.store.RoleReferenceResolver;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;
import org.elasticsearch.xpack.core.security.authz.store.RolesRetrievalResult;
import org.elasticsearch.xpack.security.authc.ApiKeyService;
import org.elasticsearch.xpack.security.authc.service.ServiceAccountService;
import org.elasticsearch.xpack.security.authz.store.RoleProviders;

public class RoleDescriptorStore
implements RoleReferenceResolver {
    private static final Logger logger = LogManager.getLogger(RoleDescriptorStore.class);
    private final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RoleDescriptorStore.class);
    private final RoleProviders roleProviders;
    private final ApiKeyService apiKeyService;
    private final ServiceAccountService serviceAccountService;
    private final XPackLicenseState licenseState;
    private final ThreadContext threadContext;
    private final Consumer<Collection<RoleDescriptor>> effectiveRoleDescriptorsConsumer;
    private final Cache<String, Boolean> negativeLookupCache;

    public RoleDescriptorStore(RoleProviders roleProviders, ApiKeyService apiKeyService, ServiceAccountService serviceAccountService, Cache<String, Boolean> negativeLookupCache, XPackLicenseState licenseState, ThreadContext threadContext, Consumer<Collection<RoleDescriptor>> effectiveRoleDescriptorsConsumer) {
        this.roleProviders = roleProviders;
        this.apiKeyService = Objects.requireNonNull(apiKeyService);
        this.serviceAccountService = Objects.requireNonNull(serviceAccountService);
        this.licenseState = Objects.requireNonNull(licenseState);
        this.threadContext = threadContext;
        this.effectiveRoleDescriptorsConsumer = Objects.requireNonNull(effectiveRoleDescriptorsConsumer);
        this.negativeLookupCache = negativeLookupCache;
    }

    public void resolveNamedRoleReference(RoleReference.NamedRoleReference namedRoleReference, ActionListener<RolesRetrievalResult> listener) {
        Set<String> roleNames = Set.copyOf(new HashSet<String>(List.of(namedRoleReference.getRoleNames())));
        if (roleNames.isEmpty()) {
            listener.onResponse((Object)RolesRetrievalResult.EMPTY);
        } else if (roleNames.equals(Set.of(ReservedRolesStore.SUPERUSER_ROLE_DESCRIPTOR.getName()))) {
            listener.onResponse((Object)RolesRetrievalResult.SUPERUSER);
        } else {
            this.resolveRoleNames(roleNames, listener);
        }
    }

    public void resolveApiKeyRoleReference(RoleReference.ApiKeyRoleReference apiKeyRoleReference, ActionListener<RolesRetrievalResult> listener) {
        List<RoleDescriptor> roleDescriptors = this.apiKeyService.parseRoleDescriptorsBytes(apiKeyRoleReference.getApiKeyId(), apiKeyRoleReference.getRoleDescriptorsBytes(), apiKeyRoleReference.getRoleType());
        RolesRetrievalResult rolesRetrievalResult = new RolesRetrievalResult();
        rolesRetrievalResult.addDescriptors(Set.copyOf(roleDescriptors));
        assert (apiKeyRoleReference.getRoleType() == RoleReference.ApiKeyRoleType.ASSIGNED && rolesRetrievalResult.getRoleDescriptors().stream().filter(RoleDescriptor::hasRestriction).count() <= 1L || apiKeyRoleReference.getRoleType() == RoleReference.ApiKeyRoleType.LIMITED_BY && rolesRetrievalResult.getRoleDescriptors().stream().noneMatch(RoleDescriptor::hasRestriction)) : "there should be zero limited-by role descriptors with restriction and no more than one assigned";
        listener.onResponse((Object)rolesRetrievalResult);
    }

    public void resolveBwcApiKeyRoleReference(RoleReference.BwcApiKeyRoleReference bwcApiKeyRoleReference, ActionListener<RolesRetrievalResult> listener) {
        List<RoleDescriptor> roleDescriptors = this.apiKeyService.parseRoleDescriptors(bwcApiKeyRoleReference.getApiKeyId(), bwcApiKeyRoleReference.getRoleDescriptorsMap(), bwcApiKeyRoleReference.getRoleType());
        RolesRetrievalResult rolesRetrievalResult = new RolesRetrievalResult();
        rolesRetrievalResult.addDescriptors(Set.copyOf(roleDescriptors));
        listener.onResponse((Object)rolesRetrievalResult);
    }

    public void resolveServiceAccountRoleReference(RoleReference.ServiceAccountRoleReference roleReference, ActionListener<RolesRetrievalResult> listener) {
        ServiceAccountService.getRoleDescriptorForPrincipal(roleReference.getPrincipal(), (ActionListener<RoleDescriptor>)listener.map(roleDescriptor -> {
            RolesRetrievalResult rolesRetrievalResult = new RolesRetrievalResult();
            rolesRetrievalResult.addDescriptors(Set.of(roleDescriptor));
            return rolesRetrievalResult;
        }));
    }

    public void resolveCrossClusterAccessRoleReference(RoleReference.CrossClusterAccessRoleReference crossClusterAccessRoleReference, ActionListener<RolesRetrievalResult> listener) {
        Set roleDescriptors = crossClusterAccessRoleReference.getRoleDescriptorsBytes().toRoleDescriptors();
        for (RoleDescriptor roleDescriptor : roleDescriptors) {
            if (!roleDescriptor.hasPrivilegesOtherThanIndex()) continue;
            String message = "Role descriptor for cross cluster access can only contain index privileges but other privileges found for subject [" + crossClusterAccessRoleReference.getUserPrincipal() + "]";
            logger.debug("{}. Invalid role descriptor: [{}]", (Object)message, (Object)roleDescriptor);
            listener.onFailure((Exception)new IllegalArgumentException(message));
            return;
        }
        if (roleDescriptors.isEmpty()) {
            logger.debug(() -> "Cross cluster access role reference [" + crossClusterAccessRoleReference.id() + "] resolved to an empty role descriptor set");
            listener.onResponse((Object)RolesRetrievalResult.EMPTY);
            return;
        }
        RolesRetrievalResult rolesRetrievalResult = new RolesRetrievalResult();
        rolesRetrievalResult.addDescriptors(Set.copyOf(roleDescriptors));
        listener.onResponse((Object)rolesRetrievalResult);
    }

    private void resolveRoleNames(Set<String> roleNames, ActionListener<RolesRetrievalResult> listener) {
        this.roleDescriptors(roleNames, (ActionListener<RolesRetrievalResult>)ActionListener.wrap(rolesRetrievalResult -> {
            boolean missingRoles;
            this.logDeprecatedRoles(rolesRetrievalResult.getRoleDescriptors());
            boolean bl = missingRoles = !rolesRetrievalResult.getMissingRoles().isEmpty();
            if (missingRoles) {
                logger.debug(() -> Strings.format((String)"Could not find roles with names %s", (Object[])new Object[]{rolesRetrievalResult.getMissingRoles()}));
            }
            Set<RoleDescriptor> effectiveDescriptors = this.maybeSkipRolesUsingDocumentOrFieldLevelSecurity(rolesRetrievalResult.getRoleDescriptors());
            logger.trace(() -> Strings.format((String)"Exposing effective role descriptors [%s] for role names [%s]", (Object[])new Object[]{effectiveDescriptors, roleNames}));
            this.effectiveRoleDescriptorsConsumer.accept(Collections.unmodifiableCollection(effectiveDescriptors));
            RolesRetrievalResult finalResult = new RolesRetrievalResult();
            finalResult.addDescriptors(effectiveDescriptors);
            finalResult.setMissingRoles(rolesRetrievalResult.getMissingRoles());
            if (!rolesRetrievalResult.isSuccess()) {
                finalResult.setFailure();
            }
            listener.onResponse((Object)finalResult);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private Set<RoleDescriptor> maybeSkipRolesUsingDocumentOrFieldLevelSecurity(Set<RoleDescriptor> roleDescriptors) {
        if (!this.shouldSkipRolesUsingDocumentOrFieldLevelSecurity(roleDescriptors)) {
            return roleDescriptors;
        }
        Map partitionedRoleDescriptors = roleDescriptors.stream().collect(Collectors.partitioningBy(RoleDescriptor::isUsingDocumentOrFieldLevelSecurity, Collectors.toSet()));
        Set roleDescriptorsToSkip = partitionedRoleDescriptors.get(true);
        logger.warn("User roles [{}] are disabled because they require field or document level security. The current license is non-compliant for [field and document level security].", (Object)roleDescriptorsToSkip.stream().map(RoleDescriptor::getName).collect(Collectors.joining(",")));
        return partitionedRoleDescriptors.get(false);
    }

    private boolean shouldSkipRolesUsingDocumentOrFieldLevelSecurity(Set<RoleDescriptor> roleDescriptors) {
        return roleDescriptors.stream().anyMatch(RoleDescriptor::isUsingDocumentOrFieldLevelSecurity) && !SecurityField.DOCUMENT_LEVEL_SECURITY_FEATURE.checkWithoutTracking(this.licenseState);
    }

    private void roleDescriptors(Set<String> roleNames, ActionListener<RolesRetrievalResult> rolesResultListener) {
        Set<String> filteredRoleNames = roleNames.stream().filter(s -> {
            if (this.negativeLookupCache.get(s) != null) {
                logger.debug(() -> "Requested role [" + s + "] does not exist (cached)");
                return false;
            }
            return true;
        }).collect(Collectors.toSet());
        this.loadRoleDescriptorsAsync(filteredRoleNames, rolesResultListener);
    }

    void logDeprecatedRoles(Set<RoleDescriptor> roleDescriptors) {
        roleDescriptors.stream().filter(rd -> Boolean.TRUE.equals(rd.getMetadata().get("_deprecated"))).forEach(rd -> {
            String reason = Objects.toString(rd.getMetadata().get("_deprecated_reason"), "Please check the documentation");
            this.deprecationLogger.critical(DeprecationCategory.SECURITY, "deprecated_role-" + rd.getName(), "The role [" + rd.getName() + "] is deprecated and will be removed in a future version of Elasticsearch. " + reason, new Object[0]);
        });
    }

    private void loadRoleDescriptorsAsync(Set<String> roleNames, ActionListener<RolesRetrievalResult> listener) {
        RolesRetrievalResult rolesResult = new RolesRetrievalResult();
        List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> asyncRoleProviders = this.roleProviders.getProviders();
        ContextPreservingActionListener descriptorsListener = ContextPreservingActionListener.wrapPreservingContext((ActionListener)ActionListener.wrap(ignore -> {
            rolesResult.setMissingRoles(roleNames);
            listener.onResponse((Object)rolesResult);
        }, arg_0 -> listener.onFailure(arg_0)), (ThreadContext)this.threadContext);
        Predicate<RoleRetrievalResult> iterationPredicate = result -> !roleNames.isEmpty();
        new IteratingActionListener((ActionListener)descriptorsListener, (rolesProvider, providerListener) -> rolesProvider.accept(roleNames, ActionListener.wrap(result -> {
            if (result.isSuccess()) {
                logger.debug(() -> Strings.format((String)"Roles [%s] were resolved by [%s]", (Object[])new Object[]{result.getDescriptors().stream().map(RoleDescriptor::getName).collect(Collectors.joining(",")), rolesProvider}));
                Set resolvedDescriptors = result.getDescriptors();
                rolesResult.addDescriptors(resolvedDescriptors);
                for (RoleDescriptor descriptor : resolvedDescriptors) {
                    roleNames.remove(descriptor.getName());
                }
            } else {
                logger.warn(() -> Strings.format((String)"role [%s] retrieval failed from [%s]", (Object[])new Object[]{roleNames, rolesProvider}), (Throwable)result.getFailure());
                rolesResult.setFailure();
            }
            providerListener.onResponse(result);
        }, arg_0 -> ((ActionListener)providerListener).onFailure(arg_0))), asyncRoleProviders, this.threadContext, Function.identity(), iterationPredicate).run();
    }
}

