/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.user.InternalUsers;

public final class AuthorizationUtils {
    private static final Predicate<String> INTERNAL_PREDICATE = Automatons.predicate((String[])new String[]{"internal:*"});

    private AuthorizationUtils() {
    }

    public static boolean shouldReplaceUserWithSystem(ThreadContext threadContext, String action) {
        if (!threadContext.isSystemContext() && !AuthorizationUtils.isInternalAction(action)) {
            return false;
        }
        Authentication authentication = (Authentication)threadContext.getTransient("_xpack_security_authentication");
        if (authentication == null && threadContext.getTransient("action.origin") == null) {
            return true;
        }
        String originatingAction = (String)threadContext.getTransient("_originating_action_name");
        return originatingAction != null && !AuthorizationUtils.isInternalAction(originatingAction);
    }

    public static boolean shouldSetUserBasedOnActionOrigin(ThreadContext context) {
        String actionOrigin = (String)context.getTransient("action.origin");
        Authentication authentication = (Authentication)context.getTransient("_xpack_security_authentication");
        return actionOrigin != null && authentication == null;
    }

    public static void switchUserBasedOnActionOriginAndExecute(ThreadContext threadContext, SecurityContext securityContext, TransportVersion version, Consumer<ThreadContext.StoredContext> consumer) {
        String actionOrigin = (String)threadContext.getTransient("action.origin");
        if (actionOrigin == null) {
            assert (false) : "cannot switch user if there is no action origin";
            throw new IllegalStateException("cannot switch user if there is no action origin");
        }
        switch (actionOrigin) {
            case "security": {
                securityContext.executeAsInternalUser(InternalUsers.XPACK_SECURITY_USER, version, consumer);
                break;
            }
            case "security_profile": {
                securityContext.executeAsInternalUser(InternalUsers.SECURITY_PROFILE_USER, version, consumer);
                break;
            }
            case "post_write_refresh": {
                securityContext.executeAsInternalUser(InternalUsers.STORAGE_USER, version, consumer);
                break;
            }
            case "data_stream_lifecycle": {
                securityContext.executeAsInternalUser(InternalUsers.DATA_STREAM_LIFECYCLE_USER, version, consumer);
                break;
            }
            case "watcher": 
            case "ml": 
            case "monitoring": 
            case "transform": 
            case "deprecation": 
            case "persistent_tasks": 
            case "rollup": 
            case "index_lifecycle": 
            case "enrich": 
            case "idp": 
            case "ingest": 
            case "profiling": 
            case "apm": 
            case "stack": 
            case "searchable_snapshots": 
            case "logstash_management": 
            case "fleet": 
            case "enterprise_search": 
            case "connectors": 
            case "inference": 
            case "tasks": {
                securityContext.executeAsInternalUser(InternalUsers.XPACK_USER, version, consumer);
                break;
            }
            case "async_search": {
                securityContext.executeAsInternalUser(InternalUsers.ASYNC_SEARCH_USER, version, consumer);
                break;
            }
            case "synonyms": {
                securityContext.executeAsInternalUser(InternalUsers.SYNONYMS_USER, version, consumer);
                break;
            }
            default: {
                assert (false) : "action.origin [" + actionOrigin + "] is unknown!";
                throw new IllegalStateException("action.origin [" + actionOrigin + "] should always be a known value");
            }
        }
    }

    private static boolean isInternalAction(String action) {
        return INTERNAL_PREDICATE.test(action);
    }
}

