/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.CheckedBiConsumer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.security.ScrollHelper;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheAction;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.DeleteRoleMappingRequest;
import org.elasticsearch.xpack.core.security.action.rolemapping.PutRoleMappingRequest;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.authc.support.mapper.ExpressionRoleMapping;
import org.elasticsearch.xpack.core.security.authc.support.mapper.TemplateRoleName;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionModel;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

public class NativeRoleMappingStore
implements UserRoleMapper {
    private static final Logger logger = LogManager.getLogger(NativeRoleMappingStore.class);
    static final String DOC_TYPE_FIELD = "doc_type";
    static final String DOC_TYPE_ROLE_MAPPING = "role-mapping";
    private static final String ID_PREFIX = "role-mapping_";
    public static final Setting<Boolean> LAST_LOAD_CACHE_ENABLED_SETTING = Setting.boolSetting((String)"xpack.security.authz.store.role_mappings.last_load_cache.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered});
    private final Settings settings;
    private final Client client;
    private final SecurityIndexManager securityIndex;
    private final ScriptService scriptService;
    private final List<String> realmsToRefresh = new CopyOnWriteArrayList<String>();
    private final boolean lastLoadCacheEnabled;
    private final AtomicReference<List<ExpressionRoleMapping>> lastLoadRef = new AtomicReference<Object>(null);

    public NativeRoleMappingStore(Settings settings, Client client, SecurityIndexManager securityIndex, ScriptService scriptService) {
        this.settings = settings;
        this.client = client;
        this.securityIndex = securityIndex;
        this.scriptService = scriptService;
        this.lastLoadCacheEnabled = (Boolean)LAST_LOAD_CACHE_ENABLED_SETTING.get(settings);
    }

    private static String getNameFromId(String id) {
        assert (id.startsWith(ID_PREFIX));
        return id.substring(ID_PREFIX.length());
    }

    static String getIdForName(String name) {
        return ID_PREFIX + name;
    }

    protected void loadMappings(ActionListener<List<ExpressionRoleMapping>> listener) {
        if (!this.securityIndex.isIndexUpToDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
            return;
        }
        TermQueryBuilder query = QueryBuilders.termQuery((String)DOC_TYPE_FIELD, (String)DOC_TYPE_ROLE_MAPPING);
        Supplier supplier = this.client.threadPool().getThreadContext().newRestorableContext(false);
        try (ThreadContext.StoredContext ignore = this.client.threadPool().getThreadContext().stashWithOrigin("security");){
            SearchRequest request = (SearchRequest)this.client.prepareSearch(new String[]{".security"}).setScroll((TimeValue)SearchService.DEFAULT_KEEPALIVE_SETTING.get(this.settings)).setQuery((QueryBuilder)query).setSize(1000).setFetchSource(true).request();
            request.indicesOptions().ignoreUnavailable();
            ScrollHelper.fetchAllByEntity((Client)this.client, (SearchRequest)request, (ActionListener)new ContextPreservingActionListener(supplier, ActionListener.wrap(mappings -> {
                List<ExpressionRoleMapping> mappingList = mappings.stream().filter(Objects::nonNull).toList();
                logger.debug("successfully loaded [{}] role-mapping(s) from [{}]", (Object)mappingList.size(), (Object)this.securityIndex.aliasName());
                if (this.lastLoadCacheEnabled) {
                    logger.debug("caching loaded role-mapping(s)");
                    this.lastLoadRef.set(List.copyOf(mappingList));
                }
                listener.onResponse(mappingList);
            }, ex -> {
                logger.error(() -> Strings.format((String)"failed to load role mappings from index [%s] skipping all mappings.", (Object[])new Object[]{".security"}), (Throwable)ex);
                listener.onResponse(Collections.emptyList());
            })), doc -> NativeRoleMappingStore.buildMapping(NativeRoleMappingStore.getNameFromId(doc.getId()), doc.getSourceRef()));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected static ExpressionRoleMapping buildMapping(String id, BytesReference source) {
        try (StreamInput stream = source.streamInput();){
            ExpressionRoleMapping expressionRoleMapping;
            block14: {
                XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)stream);
                try {
                    expressionRoleMapping = ExpressionRoleMapping.parse((String)id, (XContentParser)parser);
                    if (parser == null) break block14;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return expressionRoleMapping;
        }
        catch (Exception e) {
            logger.warn(() -> "Role mapping [" + id + "] cannot be parsed and will be skipped", (Throwable)e);
            return null;
        }
    }

    public void putRoleMapping(PutRoleMappingRequest request, ActionListener<Boolean> listener) {
        for (TemplateRoleName templateRoleName : request.getRoleTemplates()) {
            templateRoleName.validate(this.scriptService);
        }
        this.modifyMapping(request.getName(), this::innerPutMapping, request, listener);
    }

    public void deleteRoleMapping(DeleteRoleMappingRequest request, ActionListener<Boolean> listener) {
        this.modifyMapping(request.getName(), this::innerDeleteMapping, request, listener);
    }

    private <Request, Result> void modifyMapping(String name, CheckedBiConsumer<Request, ActionListener<Result>, Exception> inner, Request request, ActionListener<Result> listener) {
        if (!this.securityIndex.isIndexUpToDate()) {
            listener.onFailure((Exception)new IllegalStateException("Security index is not on the current version - the native realm will not be operational until the upgrade API is run on the security index"));
        } else {
            try {
                logger.trace("Modifying role mapping [{}] for [{}]", (Object)name, (Object)request.getClass().getSimpleName());
                inner.accept(request, (Object)ActionListener.wrap(r -> this.refreshRealms(listener, r), arg_0 -> listener.onFailure(arg_0)));
            }
            catch (Exception e) {
                logger.error(() -> "failed to modify role-mapping [" + name + "]", (Throwable)e);
                listener.onFailure(e);
            }
        }
    }

    private void innerPutMapping(PutRoleMappingRequest request, final ActionListener<Boolean> listener) {
        final ExpressionRoleMapping mapping = request.getMapping();
        this.securityIndex.prepareIndexIfNeededThenExecute(arg_0 -> listener.onFailure(arg_0), () -> {
            XContentBuilder xContentBuilder;
            try {
                xContentBuilder = mapping.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS, true);
            }
            catch (IOException e) {
                listener.onFailure((Exception)e);
                return;
            }
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((IndexRequest)((IndexRequestBuilder)((IndexRequestBuilder)this.client.prepareIndex(".security").setId(NativeRoleMappingStore.getIdForName(mapping.getName())).setSource(xContentBuilder).setRefreshPolicy(request.getRefreshPolicy())).setWaitForActiveShards(ActiveShardCount.NONE)).request()), (ActionListener)new ActionListener<DocWriteResponse>(){

                public void onResponse(DocWriteResponse indexResponse) {
                    boolean created = indexResponse.getResult() == DocWriteResponse.Result.CREATED;
                    listener.onResponse((Object)created);
                }

                public void onFailure(Exception e) {
                    logger.error(() -> "failed to put role-mapping [" + mapping.getName() + "]", (Throwable)e);
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).index(arg_0, arg_1));
        });
    }

    private void innerDeleteMapping(final DeleteRoleMappingRequest request, final ActionListener<Boolean> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            listener.onResponse((Object)false);
        } else if (!this.securityIndex.isAvailable(SecurityIndexManager.Availability.PRIMARY_SHARDS)) {
            listener.onFailure((Exception)((Object)frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.PRIMARY_SHARDS)));
        } else {
            this.securityIndex.checkIndexVersionThenExecute(arg_0 -> listener.onFailure(arg_0), () -> ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)((DeleteRequest)((DeleteRequestBuilder)((DeleteRequestBuilder)this.client.prepareDelete(".security", NativeRoleMappingStore.getIdForName(request.getName())).setRefreshPolicy(request.getRefreshPolicy())).setWaitForActiveShards(ActiveShardCount.NONE)).request()), (ActionListener)new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse deleteResponse) {
                    boolean deleted = deleteResponse.getResult() == DocWriteResponse.Result.DELETED;
                    listener.onResponse((Object)deleted);
                }

                public void onFailure(Exception e) {
                    logger.error(() -> "failed to delete role-mapping [" + request.getName() + "]", (Throwable)e);
                    listener.onFailure(e);
                }
            }, (arg_0, arg_1) -> ((Client)this.client).delete(arg_0, arg_1)));
        }
    }

    public void getRoleMappings(Set<String> names, ActionListener<List<ExpressionRoleMapping>> listener) {
        if (names == null || names.isEmpty()) {
            this.getMappings(listener);
        } else {
            this.getMappings((ActionListener<List<ExpressionRoleMapping>>)listener.safeMap(mappings -> mappings.stream().filter(m -> names.contains(m.getName())).toList()));
        }
    }

    private void getMappings(ActionListener<List<ExpressionRoleMapping>> listener) {
        SecurityIndexManager frozenSecurityIndex = this.securityIndex.defensiveCopy();
        if (!frozenSecurityIndex.indexExists()) {
            logger.debug("The security index does not exist - no role mappings can be loaded");
            listener.onResponse(Collections.emptyList());
            return;
        }
        List<ExpressionRoleMapping> lastLoad = this.lastLoadRef.get();
        if (frozenSecurityIndex.indexIsClosed()) {
            if (lastLoad != null) {
                assert (this.lastLoadCacheEnabled);
                logger.debug("The security index exists but is closed - returning previously cached role mappings");
                listener.onResponse(lastLoad);
            } else {
                logger.debug("The security index exists but is closed - no role mappings can be loaded");
                listener.onResponse(Collections.emptyList());
            }
        } else if (!frozenSecurityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
            ElasticsearchException unavailableReason = frozenSecurityIndex.getUnavailableReason(SecurityIndexManager.Availability.SEARCH_SHARDS);
            if (lastLoad != null) {
                assert (this.lastLoadCacheEnabled);
                logger.debug("The security index exists but is not available - returning previously cached role mappings", (Throwable)unavailableReason);
                listener.onResponse(lastLoad);
            } else {
                logger.debug("The security index exists but is not available - no role mappings can be loaded");
                listener.onFailure((Exception)((Object)unavailableReason));
            }
        } else {
            this.loadMappings(listener);
        }
    }

    @Nullable
    List<ExpressionRoleMapping> getLastLoad() {
        return this.lastLoadRef.get();
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        if (this.securityIndex.indexIsClosed() || !this.securityIndex.isAvailable(SecurityIndexManager.Availability.SEARCH_SHARDS)) {
            NativeRoleMappingStore.reportStats(listener, Collections.emptyList());
        } else {
            this.getMappings((ActionListener<List<ExpressionRoleMapping>>)ActionListener.wrap(mappings -> NativeRoleMappingStore.reportStats(listener, mappings), arg_0 -> listener.onFailure(arg_0)));
        }
    }

    private static void reportStats(ActionListener<Map<String, Object>> listener, List<ExpressionRoleMapping> mappings) {
        HashMap<String, Number> usageStats = new HashMap<String, Number>();
        usageStats.put("size", mappings.size());
        usageStats.put("enabled", mappings.stream().filter(ExpressionRoleMapping::isEnabled).count());
        listener.onResponse(usageStats);
    }

    public void onSecurityIndexStateChange(SecurityIndexManager.State previousState, SecurityIndexManager.State currentState) {
        if (SecurityIndexManager.isMoveFromRedToNonRed(previousState, currentState) || SecurityIndexManager.isIndexDeleted(previousState, currentState) || !Objects.equals(previousState.indexUUID, currentState.indexUUID) || previousState.isIndexUpToDate != currentState.isIndexUpToDate) {
            this.refreshRealms(ActionListener.noop(), null);
        }
    }

    private <Result> void refreshRealms(ActionListener<Result> listener, Result result) {
        if (this.realmsToRefresh.isEmpty()) {
            listener.onResponse(result);
            return;
        }
        String[] realmNames = this.realmsToRefresh.toArray(org.elasticsearch.common.Strings.EMPTY_ARRAY);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"security", (ActionType)ClearRealmCacheAction.INSTANCE, (ActionRequest)new ClearRealmCacheRequest().realms(realmNames), (ActionListener)ActionListener.wrap(response -> {
            logger.debug(() -> Strings.format((String)"Cleared cached in realms [%s] due to role mapping change", (Object[])new Object[]{Arrays.toString(realmNames)}));
            listener.onResponse(result);
        }, ex -> {
            logger.warn(() -> "Failed to clear cache for realms [" + Arrays.toString(realmNames) + "]", (Throwable)ex);
            listener.onFailure(ex);
        }));
    }

    public void resolveRoles(UserRoleMapper.UserData user, ActionListener<Set<String>> listener) {
        this.getRoleMappings(null, (ActionListener<List<ExpressionRoleMapping>>)ActionListener.wrap(mappings -> {
            ExpressionModel model = user.asModel();
            Set roles = mappings.stream().filter(ExpressionRoleMapping::isEnabled).filter(m -> m.getExpression().match(model)).flatMap(m -> {
                Set roleNames = m.getRoleNames(this.scriptService, model);
                logger.trace("Applying role-mapping [{}] to user-model [{}] produced role-names [{}]", (Object)m.getName(), (Object)model, (Object)roleNames);
                return roleNames.stream();
            }).collect(Collectors.toSet());
            logger.debug("Mapping user [{}] to roles [{}]", (Object)user, roles);
            listener.onResponse(roles);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void refreshRealmOnChange(CachingRealm realm) {
        this.realmsToRefresh.add(realm.name());
    }
}

