/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.server.cli;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.server.cli.JvmOption;
import org.elasticsearch.server.cli.SystemMemoryInfo;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.yaml.YamlXContent;

public final class MachineDependentHeap {
    private static final long GB = 0x40000000L;
    private static final long MAX_HEAP_SIZE = 0x7C0000000L;
    private static final long MIN_HEAP_SIZE = 0x8000000L;
    private static final int DEFAULT_HEAP_SIZE_MB = 1024;
    private static final String ELASTICSEARCH_YML = "elasticsearch.yml";
    private final SystemMemoryInfo systemMemoryInfo;

    public MachineDependentHeap(SystemMemoryInfo systemMemoryInfo) {
        this.systemMemoryInfo = systemMemoryInfo;
    }

    public List<String> determineHeapSettings(Path configDir, List<String> userDefinedJvmOptions) throws IOException, InterruptedException {
        Map<String, JvmOption> finalJvmOptions = JvmOption.findFinalOptions(userDefinedJvmOptions);
        if (JvmOption.isMaxHeapSpecified(finalJvmOptions) || JvmOption.isMinHeapSpecified(finalJvmOptions) || JvmOption.isInitialHeapSpecified(finalJvmOptions)) {
            return Collections.emptyList();
        }
        Path config = configDir.resolve(ELASTICSEARCH_YML);
        try (InputStream in = Files.newInputStream(config, new OpenOption[0]);){
            List<String> list = this.determineHeapSettings(in);
            return list;
        }
    }

    List<String> determineHeapSettings(InputStream config) {
        MachineNodeRole nodeRole = NodeRoleParser.parse(config);
        long availableSystemMemory = this.systemMemoryInfo.availableSystemMemory();
        return MachineDependentHeap.options(nodeRole.heap(availableSystemMemory));
    }

    private static List<String> options(int heapSize) {
        return List.of("-Xms" + heapSize + "m", "-Xmx" + heapSize + "m");
    }

    static class NodeRoleParser {
        NodeRoleParser() {
        }

        public static MachineNodeRole parse(InputStream config) {
            Object settings;
            try {
                XContentParser parser = YamlXContent.yamlXContent.createParser(XContentParserConfiguration.EMPTY, config);
                settings = parser.currentToken() == null && parser.nextToken() == null ? null : Settings.fromXContent((XContentParser)parser);
            }
            catch (IOException | ParsingException ex) {
                return MachineNodeRole.UNKNOWN;
            }
            if (settings != null && !settings.isEmpty()) {
                List roles = settings.getAsList("node.roles");
                if (roles.isEmpty()) {
                    return MachineNodeRole.DATA;
                }
                if (NodeRoleParser.containsOnly(roles, "master")) {
                    return MachineNodeRole.MASTER_ONLY;
                }
                if (roles.contains("ml") && NodeRoleParser.containsOnly(roles, "ml", "remote_cluster_client")) {
                    return MachineNodeRole.ML_ONLY;
                }
                return MachineNodeRole.DATA;
            }
            return MachineNodeRole.DATA;
        }

        private static <T> boolean containsOnly(Collection<T> collection, T ... items) {
            return Arrays.asList(items).containsAll(collection);
        }
    }

    static enum MachineNodeRole {
        MASTER_ONLY(m -> MachineNodeRole.mb(Math.min((long)((double)m.longValue() * 0.6), 0x7C0000000L))),
        ML_ONLY(m -> MachineNodeRole.mb(m <= 0x400000000L ? (long)((double)m.longValue() * 0.4) : (long)Math.min(6.8719476736E9 + (double)(m - 0x400000000L) * 0.1, 3.3285996544E10), 4)),
        DATA(m -> MachineNodeRole.mb(m < 0x40000000L ? Math.max((long)((double)m.longValue() * 0.4), 0x8000000L) : Math.min((long)((double)m.longValue() * 0.5), 0x7C0000000L))),
        UNKNOWN(m -> 1024);

        private final Function<Long, Integer> formula;

        private MachineNodeRole(Function<Long, Integer> formula) {
            this.formula = formula;
        }

        public int heap(long systemMemory) {
            return this.formula.apply(systemMemory);
        }

        private static int mb(long bytes) {
            return (int)(bytes / 0x100000L);
        }

        private static int mb(long bytes, int toLowerMultipleOfMb) {
            return toLowerMultipleOfMb * (int)(bytes / (long)(0x100000 * toLowerMultipleOfMb));
        }
    }
}

