/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface.embeddings;

import java.net.URI;
import java.util.Map;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.ModelConfigurations;
import org.elasticsearch.inference.ModelSecrets;
import org.elasticsearch.inference.SecretSettings;
import org.elasticsearch.inference.ServiceSettings;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.huggingface.HuggingFaceActionVisitor;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceModel;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceServiceSettings;
import org.elasticsearch.xpack.inference.services.settings.DefaultSecretSettings;

public class HuggingFaceEmbeddingsModel
extends HuggingFaceModel {
    public HuggingFaceEmbeddingsModel(String modelId, TaskType taskType, String service, Map<String, Object> serviceSettings, @Nullable Map<String, Object> secrets) {
        this(modelId, taskType, service, HuggingFaceServiceSettings.fromMap(serviceSettings), DefaultSecretSettings.fromMap(secrets));
    }

    HuggingFaceEmbeddingsModel(String modelId, TaskType taskType, String service, HuggingFaceServiceSettings serviceSettings, @Nullable DefaultSecretSettings secrets) {
        super(new ModelConfigurations(modelId, taskType, service, (ServiceSettings)serviceSettings), new ModelSecrets((SecretSettings)secrets));
    }

    public HuggingFaceEmbeddingsModel(HuggingFaceEmbeddingsModel model, HuggingFaceServiceSettings serviceSettings) {
        this(model.getModelId(), model.getTaskType(), model.getConfigurations().getService(), serviceSettings, model.getSecretSettings());
    }

    public HuggingFaceServiceSettings getServiceSettings() {
        return (HuggingFaceServiceSettings)super.getServiceSettings();
    }

    public DefaultSecretSettings getSecretSettings() {
        return (DefaultSecretSettings)super.getSecretSettings();
    }

    @Override
    public URI getUri() {
        return this.getServiceSettings().uri();
    }

    @Override
    public SecureString getApiKey() {
        return this.getSecretSettings().apiKey();
    }

    @Override
    public Integer getTokenLimit() {
        return this.getServiceSettings().maxInputTokens();
    }

    @Override
    public ExecutableAction accept(HuggingFaceActionVisitor creator) {
        return creator.create(this);
    }
}

