/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface;

import java.util.Map;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSenderFactory;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceBaseService;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceModel;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceServiceSettings;
import org.elasticsearch.xpack.inference.services.huggingface.elser.HuggingFaceElserModel;
import org.elasticsearch.xpack.inference.services.huggingface.embeddings.HuggingFaceEmbeddingsModel;

public class HuggingFaceService
extends HuggingFaceBaseService {
    public static final String NAME = "hugging_face";

    public HuggingFaceService(SetOnce<HttpRequestSenderFactory> factory, SetOnce<ServiceComponents> serviceComponents) {
        super(factory, serviceComponents);
    }

    @Override
    protected HuggingFaceModel createModel(String modelId, TaskType taskType, Map<String, Object> serviceSettings, @Nullable Map<String, Object> secretSettings, String failureMessage) {
        return switch (taskType) {
            case TaskType.TEXT_EMBEDDING -> new HuggingFaceEmbeddingsModel(modelId, taskType, NAME, serviceSettings, secretSettings);
            case TaskType.SPARSE_EMBEDDING -> new HuggingFaceElserModel(modelId, taskType, NAME, serviceSettings, secretSettings);
            default -> throw new ElasticsearchStatusException(failureMessage, RestStatus.BAD_REQUEST, new Object[0]);
        };
    }

    public void checkModelConfig(Model model, ActionListener<Model> listener) {
        if (model instanceof HuggingFaceEmbeddingsModel) {
            HuggingFaceEmbeddingsModel embeddingsModel = (HuggingFaceEmbeddingsModel)model;
            ServiceUtils.getEmbeddingSize(model, this, (ActionListener<Integer>)ActionListener.wrap(size -> listener.onResponse((Object)HuggingFaceService.updateModelWithEmbeddingDetails(embeddingsModel, size)), arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse((Object)model);
        }
    }

    private static HuggingFaceEmbeddingsModel updateModelWithEmbeddingDetails(HuggingFaceEmbeddingsModel model, int embeddingSize) {
        HuggingFaceServiceSettings serviceSettings = new HuggingFaceServiceSettings(model.getServiceSettings().uri(), null, embeddingSize, model.getTokenLimit());
        return new HuggingFaceEmbeddingsModel(model, serviceSettings);
    }

    public String name() {
        return NAME;
    }

    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.ML_INFERENCE_HF_SERVICE_ADDED;
    }
}

