/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.huggingface;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.inference.InferenceServiceResults;
import org.elasticsearch.inference.Model;
import org.elasticsearch.inference.TaskType;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.huggingface.HuggingFaceActionCreator;
import org.elasticsearch.xpack.inference.external.http.sender.HttpRequestSenderFactory;
import org.elasticsearch.xpack.inference.services.SenderService;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.huggingface.HuggingFaceModel;

public abstract class HuggingFaceBaseService
extends SenderService {
    public HuggingFaceBaseService(SetOnce<HttpRequestSenderFactory> factory, SetOnce<ServiceComponents> serviceComponents) {
        super(factory, serviceComponents);
    }

    public HuggingFaceModel parseRequestConfig(String modelId, TaskType taskType, Map<String, Object> config, Set<String> platformArchitectures) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        HuggingFaceModel model = this.createModel(modelId, taskType, serviceSettingsMap, serviceSettingsMap, TaskType.unsupportedTaskTypeErrorMsg((TaskType)taskType, (String)this.name()));
        ServiceUtils.throwIfNotEmptyMap(config, this.name());
        ServiceUtils.throwIfNotEmptyMap(serviceSettingsMap, this.name());
        return model;
    }

    public HuggingFaceModel parsePersistedConfigWithSecrets(String modelId, TaskType taskType, Map<String, Object> config, Map<String, Object> secrets) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        Map<String, Object> secretSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(secrets, "secret_settings");
        return this.createModel(modelId, taskType, serviceSettingsMap, secretSettingsMap, ServiceUtils.parsePersistedConfigErrorMsg(modelId, this.name()));
    }

    public HuggingFaceModel parsePersistedConfig(String modelId, TaskType taskType, Map<String, Object> config) {
        Map<String, Object> serviceSettingsMap = ServiceUtils.removeFromMapOrThrowIfNull(config, "service_settings");
        return this.createModel(modelId, taskType, serviceSettingsMap, null, ServiceUtils.parsePersistedConfigErrorMsg(modelId, this.name()));
    }

    protected abstract HuggingFaceModel createModel(String var1, TaskType var2, Map<String, Object> var3, Map<String, Object> var4, String var5);

    @Override
    public void doInfer(Model model, List<String> input, Map<String, Object> taskSettings, ActionListener<InferenceServiceResults> listener) {
        if (!(model instanceof HuggingFaceModel)) {
            listener.onFailure((Exception)ServiceUtils.createInvalidModelException(model));
            return;
        }
        HuggingFaceModel huggingFaceModel = (HuggingFaceModel)model;
        HuggingFaceActionCreator actionCreator = new HuggingFaceActionCreator(this.getSender(), this.getServiceComponents());
        ExecutableAction action = huggingFaceModel.accept(actionCreator);
        action.execute(input, listener);
    }
}

