/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.sender;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.inference.external.http.HttpClient;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.sender.HttpTask;
import org.elasticsearch.xpack.inference.external.http.sender.RequestTask;
import org.elasticsearch.xpack.inference.external.http.sender.ShutdownTask;

class HttpRequestExecutorService
implements ExecutorService {
    private static final Logger logger = LogManager.getLogger(HttpRequestExecutorService.class);
    private final String serviceName;
    private final BlockingQueue<HttpTask> queue;
    private final AtomicBoolean running = new AtomicBoolean(true);
    private final CountDownLatch terminationLatch = new CountDownLatch(1);
    private final HttpClientContext httpContext;
    private final HttpClient httpClient;
    private final ThreadPool threadPool;
    private final CountDownLatch startupLatch;

    @SuppressForbidden(reason="wraps a queue and handles errors appropriately")
    HttpRequestExecutorService(String serviceName, HttpClient httpClient, ThreadPool threadPool, @Nullable CountDownLatch startupLatch) {
        this(serviceName, httpClient, threadPool, new LinkedBlockingQueue<HttpTask>(), startupLatch);
    }

    @SuppressForbidden(reason="wraps a queue and handles errors appropriately")
    HttpRequestExecutorService(String serviceName, HttpClient httpClient, ThreadPool threadPool, int capacity, @Nullable CountDownLatch startupLatch) {
        this(serviceName, httpClient, threadPool, new LinkedBlockingQueue<HttpTask>(capacity), startupLatch);
    }

    @SuppressForbidden(reason="wraps a queue and handles errors appropriately")
    HttpRequestExecutorService(String serviceName, HttpClient httpClient, ThreadPool threadPool, BlockingQueue<HttpTask> queue, @Nullable CountDownLatch startupLatch) {
        this.serviceName = Objects.requireNonNull(serviceName);
        this.httpClient = Objects.requireNonNull(httpClient);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.httpContext = HttpClientContext.create();
        this.queue = queue;
        this.startupLatch = startupLatch;
    }

    public void start() {
        try {
            this.signalStartInitiated();
            while (this.running.get()) {
                this.handleTasks();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.running.set(false);
            this.notifyRequestsOfShutdown();
            this.terminationLatch.countDown();
        }
    }

    private void signalStartInitiated() {
        if (this.startupLatch != null) {
            this.startupLatch.countDown();
        }
    }

    private void handleTasks() throws InterruptedException {
        try {
            HttpTask task = this.queue.take();
            if (task.shouldShutdown() || !this.running.get()) {
                this.running.set(false);
                logger.debug(() -> Strings.format((String)"Http executor service [%s] exiting", (Object[])new Object[]{this.serviceName}));
                this.rejectTask(task);
            } else {
                this.executeTask(task);
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            logger.warn(Strings.format((String)"Http executor service [%s] failed while retrieving task for execution", (Object[])new Object[]{this.serviceName}), (Throwable)e);
        }
    }

    private void executeTask(HttpTask task) {
        try {
            task.run();
        }
        catch (Exception e) {
            logger.warn(Strings.format((String)"Http executor service [%s] failed to execute request [%s]", (Object[])new Object[]{this.serviceName, task}), (Throwable)e);
        }
    }

    private synchronized void notifyRequestsOfShutdown() {
        assert (this.isShutdown()) : "Requests should only be notified if the executor is shutting down";
        try {
            ArrayList notExecuted = new ArrayList();
            this.queue.drainTo(notExecuted);
            for (HttpTask task : notExecuted) {
                this.rejectTask(task);
            }
        }
        catch (Exception e) {
            logger.warn(Strings.format((String)"Failed to notify tasks of queuing service [%s] shutdown", (Object[])new Object[]{this.serviceName}));
        }
    }

    private void rejectTask(HttpTask task) {
        try {
            task.onRejection((Exception)new EsRejectedExecutionException(Strings.format((String)"Failed to send request, queue service [%s] has shutdown prior to executing request", (Object[])new Object[]{this.serviceName}), true));
        }
        catch (Exception e) {
            logger.warn(Strings.format((String)"Failed to notify request [%s] for service [%s] of rejection after queuing service shutdown", (Object[])new Object[]{task, this.serviceName}));
        }
    }

    public int queueSize() {
        return this.queue.size();
    }

    @Override
    public void shutdown() {
        if (this.running.compareAndSet(true, false)) {
            this.queue.offer(new ShutdownTask());
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return new ArrayList<HttpTask>(this.queue);
    }

    @Override
    public boolean isShutdown() {
        return !this.running.get();
    }

    @Override
    public boolean isTerminated() {
        return this.terminationLatch.getCount() == 0L;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.terminationLatch.await(timeout, unit);
    }

    public void send(HttpRequestBase request, @Nullable TimeValue timeout, ActionListener<HttpResult> listener) {
        RequestTask task = new RequestTask((HttpUriRequest)request, this.httpClient, this.httpContext, timeout, this.threadPool, listener);
        if (this.isShutdown()) {
            EsRejectedExecutionException rejected = new EsRejectedExecutionException(Strings.format((String)"Failed to enqueue task because the http executor service [%s] has already shutdown", (Object[])new Object[]{this.serviceName}), true);
            task.onRejection((Exception)rejected);
            return;
        }
        boolean added = this.queue.offer(task);
        if (!added) {
            EsRejectedExecutionException rejected = new EsRejectedExecutionException(Strings.format((String)"Failed to execute task because the http executor service [%s] queue is full", (Object[])new Object[]{this.serviceName}), false);
            task.onRejection((Exception)rejected);
        } else if (this.isShutdown()) {
            this.notifyRequestsOfShutdown();
        }
    }

    @Override
    public void execute(Runnable runnable) {
        throw new UnsupportedOperationException("use send instead");
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        throw new UnsupportedOperationException("use send instead");
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        throw new UnsupportedOperationException("use send instead");
    }

    @Override
    public Future<?> submit(Runnable task) {
        throw new UnsupportedOperationException("use send instead");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        throw new UnsupportedOperationException("use send instead");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException("use send instead");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException("use send instead");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException("use send instead");
    }
}

