/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http.retry;

import java.util.List;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;

public class RetrySettings {
    public static final Setting<TimeValue> RETRY_INITIAL_DELAY_SETTING = Setting.timeSetting((String)"xpack.inference.http.retry.initial_delay", (TimeValue)TimeValue.timeValueSeconds((long)1L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> RETRY_MAX_DELAY_BOUND_SETTING = Setting.timeSetting((String)"xpack.inference.http.retry.max_delay_bound", (TimeValue)TimeValue.timeValueSeconds((long)5L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    public static final Setting<TimeValue> RETRY_TIMEOUT_SETTING = Setting.timeSetting((String)"xpack.inference.http.retry.timeout", (TimeValue)TimeValue.timeValueSeconds((long)30L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final InternalSettings internalSettings;

    public RetrySettings(Settings settings) {
        TimeValue initialDelay = (TimeValue)RETRY_INITIAL_DELAY_SETTING.get(settings);
        TimeValue maxDelayBound = (TimeValue)RETRY_MAX_DELAY_BOUND_SETTING.get(settings);
        TimeValue timeoutValue = (TimeValue)RETRY_TIMEOUT_SETTING.get(settings);
        this.internalSettings = new InternalSettings(initialDelay, maxDelayBound, timeoutValue);
    }

    public InternalSettings getSettings() {
        return this.internalSettings;
    }

    public static List<Setting<?>> getSettingsDefinitions() {
        return List.of(RETRY_INITIAL_DELAY_SETTING, RETRY_MAX_DELAY_BOUND_SETTING, RETRY_TIMEOUT_SETTING);
    }

    public record InternalSettings(TimeValue initialDelay, TimeValue maxDelayBound, TimeValue timeoutValue) {
    }
}

