/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.util.List;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;

public class HttpSettings {
    static final Setting<ByteSizeValue> MAX_HTTP_RESPONSE_SIZE = Setting.byteSizeSetting((String)"xpack.inference.http.max_response_size", (ByteSizeValue)new ByteSizeValue(10L, ByteSizeUnit.MB), (ByteSizeValue)ByteSizeValue.ONE, (ByteSizeValue)new ByteSizeValue(50L, ByteSizeUnit.MB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private volatile ByteSizeValue maxResponseSize;

    public HttpSettings(Settings settings, ClusterService clusterService) {
        this.maxResponseSize = (ByteSizeValue)MAX_HTTP_RESPONSE_SIZE.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(MAX_HTTP_RESPONSE_SIZE, this::setMaxResponseSize);
    }

    public ByteSizeValue getMaxResponseSize() {
        return this.maxResponseSize;
    }

    private void setMaxResponseSize(ByteSizeValue maxResponseSize) {
        this.maxResponseSize = maxResponseSize;
    }

    public static List<Setting<?>> getSettings() {
        return List.of(MAX_HTTP_RESPONSE_SIZE);
    }
}

