/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.core.Strings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.common.socket.SocketAccess;
import org.elasticsearch.xpack.inference.external.http.HttpResult;
import org.elasticsearch.xpack.inference.external.http.HttpSettings;
import org.elasticsearch.xpack.inference.logging.ThrottlerManager;

public class HttpClient
implements Closeable {
    private static final Logger logger = LogManager.getLogger(HttpClient.class);
    private final CloseableHttpAsyncClient client;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.CREATED);
    private final ThreadPool threadPool;
    private final HttpSettings settings;
    private final ThrottlerManager throttlerManager;

    public static HttpClient create(HttpSettings settings, ThreadPool threadPool, PoolingNHttpClientConnectionManager connectionManager, ThrottlerManager throttlerManager) {
        CloseableHttpAsyncClient client = HttpClient.createAsyncClient(Objects.requireNonNull(connectionManager));
        return new HttpClient(settings, client, threadPool, throttlerManager);
    }

    private static CloseableHttpAsyncClient createAsyncClient(PoolingNHttpClientConnectionManager connectionManager) {
        HttpAsyncClientBuilder clientBuilder = HttpAsyncClientBuilder.create();
        clientBuilder.setConnectionManager((NHttpClientConnectionManager)connectionManager);
        clientBuilder.disableCookieManagement();
        return clientBuilder.build();
    }

    HttpClient(HttpSettings settings, CloseableHttpAsyncClient asyncClient, ThreadPool threadPool, ThrottlerManager throttlerManager) {
        this.settings = Objects.requireNonNull(settings);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.client = Objects.requireNonNull(asyncClient);
        this.throttlerManager = Objects.requireNonNull(throttlerManager);
    }

    public void start() {
        if (this.status.compareAndSet(Status.CREATED, Status.STARTED)) {
            this.client.start();
        }
    }

    public void send(final HttpUriRequest request, HttpClientContext context, final ActionListener<HttpResult> listener) throws IOException {
        assert (this.status.get() == Status.STARTED) : "call start() before attempting to send a request";
        SocketAccess.doPrivileged(() -> this.client.execute(request, (HttpContext)context, (FutureCallback)new FutureCallback<HttpResponse>(){

            public void completed(HttpResponse response) {
                HttpClient.this.respondUsingUtilityThread(response, request, (ActionListener<HttpResult>)listener);
            }

            public void failed(Exception ex) {
                HttpClient.this.throttlerManager.warn(logger, Strings.format((String)"Request [%s] failed", (Object[])new Object[]{request.getRequestLine()}), ex);
                HttpClient.this.failUsingUtilityThread(ex, (ActionListener<HttpResult>)listener);
            }

            public void cancelled() {
                HttpClient.this.failUsingUtilityThread(new CancellationException(Strings.format((String)"Request [%s] was cancelled", (Object[])new Object[]{request.getRequestLine()})), (ActionListener<HttpResult>)listener);
            }
        }));
    }

    private void respondUsingUtilityThread(HttpResponse response, HttpUriRequest request, ActionListener<HttpResult> listener) {
        this.threadPool.executor("inference_utility").execute(() -> {
            try {
                listener.onResponse((Object)HttpResult.create(this.settings.getMaxResponseSize(), response));
            }
            catch (Exception e) {
                this.throttlerManager.warn(logger, Strings.format((String)"Failed to create http result for [%s]", (Object[])new Object[]{request.getRequestLine()}), e);
                listener.onFailure(e);
            }
        });
    }

    private void failUsingUtilityThread(Exception exception, ActionListener<HttpResult> listener) {
        this.threadPool.executor("inference_utility").execute(() -> listener.onFailure(exception));
    }

    @Override
    public void close() throws IOException {
        this.status.set(Status.STOPPED);
        this.client.close();
    }

    static enum Status {
        CREATED,
        STARTED,
        STOPPED;

    }
}

